/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static boolean needsEscape(int codePoint) {
        return codePoint == 35 || codePoint == 33 || codePoint == 61 || codePoint == 58;
    }

    public static boolean needsEscapeForKey(int codePoint) {
        return Character.isSpaceChar(codePoint) || PropertiesUtil.needsEscape(codePoint);
    }

    public static boolean needsEscapeForValueFirst(int codePoint) {
        return PropertiesUtil.needsEscapeForKey(codePoint);
    }

    public static boolean needsEscapeForValueSubsequent(int codePoint) {
        return PropertiesUtil.needsEscape(codePoint);
    }

    public static String quotePropertyName(String name) {
        int length = name.length();
        int i = 0;
        while (i < length) {
            int cp = name.codePointAt(i);
            if (PropertiesUtil.needsEscapeForKey(cp)) {
                StringBuilder b = new StringBuilder(length + (length >> 2));
                b.append(name, 0, i);
                b.append('\\').appendCodePoint(cp);
                i = name.offsetByCodePoints(i, 1);
                while (i < length) {
                    cp = name.codePointAt(i);
                    if (PropertiesUtil.needsEscapeForKey(cp)) {
                        b.append('\\');
                    }
                    b.appendCodePoint(cp);
                    i = name.offsetByCodePoints(i, 1);
                }
                return b.toString();
            }
            i = name.offsetByCodePoints(i, 1);
        }
        return name;
    }

    public static String quotePropertyValue(String value) {
        int length = value.length();
        int i = 0;
        while (i < length) {
            int cp = value.codePointAt(i);
            if (i == 0 ? PropertiesUtil.needsEscapeForValueFirst(cp) : PropertiesUtil.needsEscapeForValueSubsequent(cp)) {
                StringBuilder b = new StringBuilder(length + (length >> 2));
                b.append(value, 0, i);
                b.append('\\').appendCodePoint(cp);
                i = value.offsetByCodePoints(i, 1);
                while (i < length) {
                    cp = value.codePointAt(i);
                    if (PropertiesUtil.needsEscapeForValueSubsequent(cp)) {
                        b.append('\\');
                    }
                    b.appendCodePoint(cp);
                    i = value.offsetByCodePoints(i, 1);
                }
                return b.toString();
            }
            i = value.offsetByCodePoints(i, 1);
        }
        return value;
    }
}

