/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.proxy;

import io.quarkus.deployment.proxy.InjectIntoClassloaderClassOutput;
import io.quarkus.deployment.proxy.ProxyConfiguration;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class ProxyFactory<T> {
    private final String proxyName;
    private final ClassLoader classLoader;
    private final String superClassName;
    private final List<Method> methods;
    private final ClassCreator.Builder classBuilder;
    private boolean classDefined = false;
    private final Object lock = new Object();
    private Constructor<?> constructor;
    private Constructor<?> injectConstructor;

    public ProxyFactory(ProxyConfiguration<T> configuration) {
        Objects.requireNonNull(configuration.getAnchorClass(), "anchorClass must be set");
        Objects.requireNonNull(configuration.getProxyNameSuffix(), "proxyNameSuffix must be set");
        this.proxyName = configuration.getProxyName();
        Class superClass = configuration.getSuperClass() != null ? configuration.getSuperClass() : Object.class;
        this.superClassName = superClass.getName();
        if (!configuration.isAllowPackagePrivate() && !Modifier.isPublic(superClass.getModifiers())) {
            throw new IllegalArgumentException("A proxy cannot be created for class " + this.superClassName + " because the it is not public");
        }
        if (!this.findConstructor(superClass, configuration.isAllowPackagePrivate(), true)) {
            throw new IllegalArgumentException("A proxy cannot be created for class " + this.superClassName + " because it does contain a no-arg constructor");
        }
        if (Modifier.isFinal(superClass.getModifiers())) {
            throw new IllegalArgumentException("A proxy cannot be created for class " + this.superClassName + " because it is a final class");
        }
        Objects.requireNonNull(configuration.getClassLoader(), "classLoader must be set");
        this.classLoader = configuration.getClassLoader();
        this.methods = new ArrayList<Method>(superClass.getMethods().length);
        this.addMethodsOfClass(superClass);
        for (Class<?> additionalInterface : configuration.getAdditionalInterfaces()) {
            this.addMethodsOfClass(additionalInterface);
        }
        this.classBuilder = ClassCreator.builder().classOutput((ClassOutput)(configuration.getClassOutput() != null ? configuration.getClassOutput() : new InjectIntoClassloaderClassOutput(configuration.getClassLoader()))).className(this.proxyName).superClass(this.superClassName);
        if (!configuration.getAdditionalInterfaces().isEmpty()) {
            this.classBuilder.interfaces(configuration.getAdditionalInterfaces().toArray(new Class[0]));
        }
    }

    private boolean findConstructor(Class<?> clazz, boolean allowPackagePrivate, boolean allowInject) {
        Constructor<?>[] ctors = clazz.getDeclaredConstructors();
        if (allowInject) {
            for (Constructor<?> constructor : ctors) {
                if (!constructor.isAnnotationPresent(Inject.class) && (ctors.length != 1 || constructor.getParameterCount() <= 0)) continue;
                if (!this.isModifiedCorrect(allowPackagePrivate, constructor)) {
                    return false;
                }
                for (Class<?> i : constructor.getParameterTypes()) {
                    if (!i.isAnnotationPresent(ConfigRoot.class) && i != RuntimeValue.class) {
                        return false;
                    }
                    if (this.findConstructor(i, allowPackagePrivate, false)) continue;
                    return false;
                }
                this.injectConstructor = constructor;
                return true;
            }
        }
        for (Constructor<?> constructor : ctors) {
            if (constructor.getParameterCount() != 0) continue;
            this.injectConstructor = constructor;
            return this.isModifiedCorrect(allowPackagePrivate, constructor);
        }
        return false;
    }

    private boolean isModifiedCorrect(boolean allowPackagePrivate, Constructor<?> constructor) {
        if (allowPackagePrivate) {
            return !Modifier.isPrivate(constructor.getModifiers());
        }
        return Modifier.isPublic(constructor.getModifiers()) || Modifier.isProtected(constructor.getModifiers());
    }

    private void addMethodsOfClass(Class<?> clazz) {
        this.addMethodsOfClass(clazz, new HashSet<MethodKey>());
    }

    private void addMethodsOfClass(Class<?> clazz, Set<MethodKey> seen) {
        for (Method methodInfo : clazz.getDeclaredMethods()) {
            MethodKey key = new MethodKey(methodInfo.getReturnType(), methodInfo.getName(), methodInfo.getParameterTypes());
            if (seen.contains(key)) continue;
            seen.add(key);
            if (methodInfo.getName().equals("finalize") && methodInfo.getParameterCount() == 0) continue;
            int modifiers = methodInfo.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers) && clazz != Object.class) {
                throw new RuntimeException("Public method " + methodInfo + " cannot be proxied as it is final");
            }
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || methodInfo.getName().equals("<init>")) continue;
            this.methods.add(methodInfo);
        }
        if (clazz.getSuperclass() != null) {
            this.addMethodsOfClass(clazz.getSuperclass(), seen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<? extends T> defineClass() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.classDefined) {
                this.doDefineClass();
                if (this.injectConstructor == null) {
                    try {
                        this.constructor = this.loadClass().getConstructor(InvocationHandler.class);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    ArrayList args = new ArrayList();
                    args.add(InvocationHandler.class);
                    args.addAll(Arrays.asList(this.injectConstructor.getParameterTypes()));
                    this.constructor = this.loadClass().getConstructor((Class[])args.toArray(Class[]::new));
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                this.classDefined = true;
            }
        }
        return this.loadClass();
    }

    private void doDefineClass() {
        try (ClassCreator cc = this.classBuilder.build();){
            FieldDescriptor invocationHandlerField = ((FieldCreator)cc.getFieldCreator("invocationHandler", InvocationHandler.class).setModifiers(2)).getFieldDescriptor();
            try (MethodCreator ctor = cc.getMethodCreator(MethodDescriptor.ofConstructor((String)this.proxyName, (String[])new String[0]));){
                ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)this.superClassName, (String[])new String[0]), ctor.getThis(), new ResultHandle[0]);
                ctor.writeInstanceField(invocationHandlerField, ctor.getThis(), ctor.loadNull());
                ctor.returnValue(null);
            }
            Class[] parameterTypes = this.injectConstructor.getParameterTypes();
            ArrayList args = new ArrayList();
            args.add(InvocationHandler.class);
            args.addAll(Arrays.asList(parameterTypes));
            try (MethodCreator ctor = cc.getMethodCreator(MethodDescriptor.ofConstructor((Object)this.proxyName, (Object[])args.toArray(Class[]::new)));){
                ArrayList<ResultHandle> params = new ArrayList<ResultHandle>();
                for (int i = 0; i < this.injectConstructor.getParameterCount(); ++i) {
                    params.add(ctor.getMethodParam(i + 1));
                }
                ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(this.injectConstructor.getDeclaringClass(), (Class[])parameterTypes), ctor.getThis(), (ResultHandle[])params.toArray(ResultHandle[]::new));
                ctor.writeInstanceField(invocationHandlerField, ctor.getThis(), ctor.getMethodParam(0));
                ctor.returnValue(null);
            }
            for (Method methodInfo : this.methods) {
                MethodCreator mc = (MethodCreator)cc.getMethodCreator(this.toMethodDescriptor(methodInfo)).setModifiers(1);
                try {
                    ResultHandle getDeclaredMethodParamsArray = mc.newArray(Class.class, methodInfo.getParameterCount());
                    if (methodInfo.getParameterCount() > 0) {
                        Parameter[] methodInfoParameters = methodInfo.getParameters();
                        for (int i = 0; i < methodInfo.getParameterCount(); ++i) {
                            ResultHandle paramClass = mc.loadClass(methodInfoParameters[i].getType());
                            mc.writeArrayValue(getDeclaredMethodParamsArray, i, paramClass);
                        }
                    }
                    ResultHandle method = mc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), mc.loadClass(methodInfo.getDeclaringClass()), new ResultHandle[]{mc.load(methodInfo.getName()), getDeclaredMethodParamsArray});
                    ResultHandle invokeParamsArray = mc.newArray(Object.class, methodInfo.getParameterCount());
                    for (int i = 0; i < methodInfo.getParameterCount(); ++i) {
                        mc.writeArrayValue(invokeParamsArray, i, mc.getMethodParam(i));
                    }
                    ResultHandle result = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(InvocationHandler.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Method.class, Object[].class}), mc.readInstanceField(invocationHandlerField, mc.getThis()), new ResultHandle[]{mc.getThis(), method, invokeParamsArray});
                    if (Void.TYPE.equals(methodInfo.getReturnType())) {
                        mc.returnValue(null);
                        continue;
                    }
                    mc.returnValue(result);
                }
                finally {
                    if (mc == null) continue;
                    mc.close();
                }
            }
        }
    }

    private MethodDescriptor toMethodDescriptor(Method methodInfo) {
        ArrayList<String> parameterTypesStr = new ArrayList<String>();
        for (Parameter parameter : methodInfo.getParameters()) {
            parameterTypesStr.add(parameter.getType().getName());
        }
        return MethodDescriptor.ofMethod((Object)this.proxyName, (String)methodInfo.getName(), methodInfo.getReturnType(), (Object[])parameterTypesStr.toArray(new Object[0]));
    }

    public T newInstance(InvocationHandler handler) throws IllegalAccessException, InstantiationException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.defineClass();
                Object[] args = new Object[this.constructor.getParameterCount()];
                args[0] = handler;
                Class<?>[] parameterTypes = this.constructor.getParameterTypes();
                for (int i = 1; i < this.constructor.getParameterCount(); ++i) {
                    Constructor<?> ctor = parameterTypes[i].getConstructor(new Class[0]);
                    ctor.setAccessible(true);
                    args[i] = ctor.newInstance(new Object[0]);
                }
                return (T)this.constructor.newInstance(args);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private Class<? extends T> loadClass() {
        try {
            return this.classLoader.loadClass(this.proxyName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    static class MethodKey {
        final Class<?> returnType;
        final String name;
        final Class<?>[] params;

        MethodKey(Class<?> returnType, String name, Class<?>[] params) {
            this.returnType = returnType;
            this.name = name;
            this.params = params;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            return Objects.equals(this.returnType, methodKey.returnType) && Objects.equals(this.name, methodKey.name) && Arrays.equals(this.params, methodKey.params);
        }

        public int hashCode() {
            int result = Objects.hash(this.returnType, this.name);
            result = 31 * result + Arrays.hashCode(this.params);
            return result;
        }
    }
}

