/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import io.quarkus.runtime.logging.LogCleanupFilterElement;
import io.quarkus.runtime.logging.LoggingSetupRecorder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import org.jboss.logging.Logger;
import org.jboss.logmanager.Level;

public class LogCleanupFilter
implements Filter {
    final Map<String, LogCleanupFilterElement> filterElements = new HashMap<String, LogCleanupFilterElement>();
    public static final String SHUTDOWN_MESSAGE = " [Error Occurred After Shutdown]";
    private final LoggingSetupRecorder.ShutdownNotifier shutdownNotifier;

    public LogCleanupFilter(Collection<LogCleanupFilterElement> filterElements, LoggingSetupRecorder.ShutdownNotifier shutdownNotifier) {
        this.shutdownNotifier = shutdownNotifier;
        for (LogCleanupFilterElement element : filterElements) {
            this.filterElements.put(element.getLoggerName(), element);
        }
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (record.getLevel().intValue() >= Level.ERROR.intValue() && this.shutdownNotifier.shutdown && !record.getMessage().endsWith(SHUTDOWN_MESSAGE)) {
            record.setMessage(record.getMessage() + SHUTDOWN_MESSAGE);
        }
        if (record.getLevel().intValue() > java.util.logging.Level.WARNING.intValue()) {
            return true;
        }
        LogCleanupFilterElement filterElement = this.filterElements.get(record.getLoggerName());
        if (filterElement != null) {
            for (String messageStart : filterElement.getMessageStarts()) {
                if (!record.getMessage().startsWith(messageStart)) continue;
                record.setLevel(filterElement.getTargetLevel());
                if (filterElement.getTargetLevel().intValue() <= Level.TRACE.intValue()) {
                    return Logger.getLogger((String)record.getLoggerName()).isTraceEnabled();
                }
                return Logger.getLogger((String)record.getLoggerName()).isDebugEnabled();
            }
        }
        return true;
    }
}

