/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import jakarta.annotation.Priority;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.microprofile.config.spi.Converter;
import org.wildfly.common.net.Inet;

@Priority(value=200)
public class InetAddressConverter
implements Converter<InetAddress>,
Serializable {
    private static final long serialVersionUID = 4539214213710330204L;

    public InetAddress convert(String value) {
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        InetAddress parsed = Inet.parseInetAddress((String)value);
        if (parsed != null) {
            return parsed;
        }
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unable to resolve \"" + value + "\"", e);
        }
    }
}

