/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.deployment.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.ArtifactInfoUtil;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class DefaultDataSourceDbKindBuildItem
extends MultiBuildItem {
    public static final String TEST = "test";
    private final String dbKind;
    private final Class<?> callerClass;
    private volatile String scope;

    public DefaultDataSourceDbKindBuildItem(String dbKind) {
        this.dbKind = dbKind;
        String callerClassName = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().getCanonicalName();
        try {
            this.callerClass = Thread.currentThread().getContextClassLoader().loadClass(callerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDbKind() {
        return this.dbKind;
    }

    public String getScope(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (this.scope == null) {
            Map.Entry artifact = ArtifactInfoUtil.groupIdAndArtifactId(this.callerClass, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
            for (ResolvedDependency i : curateOutcomeBuildItem.getApplicationModel().getDependencies()) {
                if (!i.getArtifactId().equals(artifact.getValue()) || !i.getGroupId().equals(artifact.getKey())) continue;
                this.scope = i.getScope();
                break;
            }
            if (this.scope == null) {
                throw new RuntimeException("Could not determine scope for " + this.dbKind);
            }
        }
        return this.scope;
    }

    public static Optional<String> resolve(Optional<String> configured, List<DefaultDataSourceDbKindBuildItem> defaultDbKinds, boolean enableImplicitResolution, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (configured.isPresent()) {
            return Optional.of(DatabaseKind.normalize((String)configured.get()));
        }
        if (!enableImplicitResolution) {
            return Optional.empty();
        }
        return DefaultDataSourceDbKindBuildItem.resolveImplicitDbKind(defaultDbKinds, curateOutcomeBuildItem);
    }

    private static Optional<String> resolveImplicitDbKind(List<DefaultDataSourceDbKindBuildItem> defaultDbKinds, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (defaultDbKinds.isEmpty()) {
            return Optional.empty();
        }
        if (defaultDbKinds.size() == 1) {
            return Optional.of(defaultDbKinds.get((int)0).dbKind);
        }
        DefaultDataSourceDbKindBuildItem testScopedDriver = null;
        for (DefaultDataSourceDbKindBuildItem i : defaultDbKinds) {
            if (!i.getScope(curateOutcomeBuildItem).equals(TEST)) continue;
            if (testScopedDriver == null) {
                testScopedDriver = i;
                continue;
            }
            return Optional.empty();
        }
        if (testScopedDriver == null) {
            return Optional.empty();
        }
        return Optional.of(testScopedDriver.dbKind);
    }
}

