/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.quarkus;

import io.quarkus.dependencies.Extension;
import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartCatalogLoader;
import io.quarkus.devtools.codestarts.CodestartException;
import io.quarkus.devtools.codestarts.CodestartPathLoader;
import io.quarkus.devtools.codestarts.CodestartProjectInput;
import io.quarkus.devtools.codestarts.CodestartStructureException;
import io.quarkus.devtools.codestarts.CodestartType;
import io.quarkus.devtools.codestarts.QuarkusPlatformCodestartResourceLoader;
import io.quarkus.devtools.codestarts.core.CodestartCatalogs;
import io.quarkus.devtools.codestarts.core.GenericCodestartCatalog;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartProjectInput;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class QuarkusCodestartCatalog
extends GenericCodestartCatalog<QuarkusCodestartProjectInput> {
    public static final String QUARKUS_CODESTARTS_DIR = "codestarts/quarkus";
    private final Map<String, String> extensionCodestartMapping;

    private QuarkusCodestartCatalog(Collection<Codestart> codestarts, Map<String, String> extensionCodestartMapping) {
        super(codestarts);
        this.extensionCodestartMapping = extensionCodestartMapping;
    }

    public static QuarkusCodestartCatalog fromQuarkusPlatformDescriptor(QuarkusPlatformDescriptor platformDescriptor) throws IOException {
        CodestartPathLoader pathLoader = QuarkusPlatformCodestartResourceLoader.platformPathLoader(platformDescriptor);
        List codestarts = CodestartCatalogLoader.loadCodestarts((CodestartPathLoader)pathLoader, (String)QUARKUS_CODESTARTS_DIR, (String[])new String[0]);
        Map<String, String> extensionCodestartMapping = QuarkusCodestartCatalog.buildCodestartMapping(platformDescriptor.getExtensions());
        return new QuarkusCodestartCatalog(codestarts, extensionCodestartMapping);
    }

    public static QuarkusCodestartCatalog fromQuarkusPlatformDescriptorAndDirectories(QuarkusPlatformDescriptor platformDescriptor, Collection<Path> directories) throws IOException {
        CodestartPathLoader pathLoader = QuarkusPlatformCodestartResourceLoader.platformPathLoader(platformDescriptor);
        Map codestarts = CodestartCatalogLoader.loadCodestarts((CodestartPathLoader)pathLoader, (String)QUARKUS_CODESTARTS_DIR, (String[])new String[0]).stream().collect(Collectors.toMap(Codestart::getName, Function.identity()));
        for (Path directory : directories) {
            Map dirCodestarts = CodestartCatalogLoader.loadUserDirectoryCodestarts((Path)directory).stream().collect(Collectors.toMap(Codestart::getName, Function.identity()));
            codestarts.putAll(dirCodestarts);
        }
        Map<String, String> extensionCodestartMapping = QuarkusCodestartCatalog.buildCodestartMapping(platformDescriptor.getExtensions());
        return new QuarkusCodestartCatalog(codestarts.values(), extensionCodestartMapping);
    }

    protected Collection<Codestart> select(QuarkusCodestartProjectInput projectInput) {
        long examplesWithCompatIssues;
        projectInput.getSelection().addNames(this.getExtensionCodestarts(projectInput));
        projectInput.getSelection().addNames(this.getToolingCodestarts(projectInput));
        List projectCodestarts = super.select((CodestartProjectInput)projectInput).stream().filter(c -> !QuarkusCodestartCatalog.isExample(c) || !projectInput.noExamples()).collect(Collectors.toCollection(ArrayList::new));
        if (!projectInput.noExamples() && projectCodestarts.stream().noneMatch(c -> QuarkusCodestartCatalog.isExample(c) && !c.getSpec().isPreselected())) {
            String languageName;
            Codestart defaultCodestart = this.codestarts.stream().filter(c -> c.isSelected(Collections.singleton(Example.RESTEASY_EXAMPLE.getKey()))).findFirst().orElseThrow(() -> new CodestartStructureException(Example.RESTEASY_EXAMPLE.getKey() + " codestart not found"));
            if (defaultCodestart.implementsLanguage(languageName = CodestartCatalogs.findLanguageName((Collection)projectCodestarts))) {
                projectCodestarts.add(defaultCodestart);
            } else {
                projectInput.log().warn(defaultCodestart.getName() + " codestart will not be applied (doesn't implement language '" + languageName + "' yet)");
            }
        }
        if ((examplesWithCompatIssues = projectCodestarts.stream().filter(QuarkusCodestartCatalog::isExample).filter(c -> c.containsTag(Tag.SINGLETON_EXAMPLE.getKey())).count()) == 1L) {
            projectCodestarts.removeIf(c -> QuarkusCodestartCatalog.isExample(c) && !c.containsTag(Tag.SINGLETON_EXAMPLE.getKey()));
        } else if (examplesWithCompatIssues > 1L) {
            throw new CodestartException("Only one extension with singleton example can be selected at a time (you can always use 'noExamples' if needed)");
        }
        return projectCodestarts;
    }

    private Set<String> getExtensionCodestarts(QuarkusCodestartProjectInput projectInput) {
        return projectInput.getExtensions().stream().map(Extensions::toGA).filter(this.extensionCodestartMapping::containsKey).map(this.extensionCodestartMapping::get).collect(Collectors.toSet());
    }

    private List<String> getToolingCodestarts(QuarkusCodestartProjectInput projectInput) {
        ArrayList<String> codestarts = new ArrayList<String>();
        codestarts.add(projectInput.getBuildTool().getKey());
        if (!projectInput.noBuildToolWrapper()) {
            switch (projectInput.getBuildTool()) {
                case GRADLE: 
                case GRADLE_KOTLIN_DSL: {
                    codestarts.add(Tooling.GRADLE_WRAPPER.getKey());
                    break;
                }
                case MAVEN: {
                    codestarts.add(Tooling.MAVEN_WRAPPER.getKey());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported build tool wrapper: " + (Object)((Object)projectInput.getBuildTool()));
                }
            }
        }
        if (!projectInput.noDockerfiles()) {
            codestarts.add(Tooling.DOCKERFILES.getKey());
        }
        return codestarts;
    }

    public static boolean isExample(Codestart codestart) {
        return codestart.getType() == CodestartType.CODE && codestart.getSpec().getTags().contains(Tag.EXAMPLE.getKey());
    }

    private static Map<String, String> buildCodestartMapping(Collection<Extension> extensions) {
        return extensions.stream().filter(e -> e.getCodestart() != null).collect(Collectors.toMap(Extensions::toGA, Extension::getCodestart));
    }

    static interface KeySupplier {
        default public String getKey() {
            return this.toString().toLowerCase().replace("_", "-");
        }
    }

    public static enum Example implements KeySupplier
    {
        RESTEASY_EXAMPLE,
        COMMANDMODE_EXAMPLE;

    }

    public static enum Tooling implements KeySupplier
    {
        GRADLE_WRAPPER,
        MAVEN_WRAPPER,
        DOCKERFILES;

    }

    public static enum Language implements KeySupplier
    {
        JAVA,
        KOTLIN,
        SCALA;

    }

    public static enum Tag implements KeySupplier
    {
        EXAMPLE,
        SINGLETON_EXAMPLE,
        MAVEN_ONLY;

    }
}

