/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.model.Extension;
import io.quarkus.registry.model.ModifiableExtensionRelease;
import io.quarkus.registry.model.Release;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class ImmutableExtensionRelease
implements Extension.ExtensionRelease {
    private final Release release;
    private final Set<Extension.ExtensionPlatformRelease> platforms;

    private ImmutableExtensionRelease(Release release, Set<Extension.ExtensionPlatformRelease> platforms) {
        this.release = release;
        this.platforms = platforms;
    }

    @Override
    @JsonProperty(value="release")
    @JsonUnwrapped
    public Release getRelease() {
        return this.release;
    }

    @Override
    @JsonProperty(value="platforms")
    public Set<Extension.ExtensionPlatformRelease> getPlatforms() {
        return this.platforms;
    }

    public final ImmutableExtensionRelease withRelease(Release value) {
        if (this.release == value) {
            return this;
        }
        Release newValue = Objects.requireNonNull(value, "release");
        return new ImmutableExtensionRelease(newValue, this.platforms);
    }

    public final ImmutableExtensionRelease withPlatforms(Extension.ExtensionPlatformRelease ... elements) {
        Set<Extension.ExtensionPlatformRelease> newValue = ImmutableExtensionRelease.createUnmodifiableSet(ImmutableExtensionRelease.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableExtensionRelease(this.release, newValue);
    }

    public final ImmutableExtensionRelease withPlatforms(Iterable<? extends Extension.ExtensionPlatformRelease> elements) {
        if (this.platforms == elements) {
            return this;
        }
        Set<Extension.ExtensionPlatformRelease> newValue = ImmutableExtensionRelease.createUnmodifiableSet(ImmutableExtensionRelease.createSafeList(elements, true, false));
        return new ImmutableExtensionRelease(this.release, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExtensionRelease && this.equalTo((ImmutableExtensionRelease)another);
    }

    private boolean equalTo(ImmutableExtensionRelease another) {
        return this.release.equals(another.release);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.release.hashCode();
        return h;
    }

    public String toString() {
        return "ExtensionRelease{release=" + this.release + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableExtensionRelease fromJson(Json json) {
        Builder builder = ImmutableExtensionRelease.builder();
        if (json.release != null) {
            builder.release(json.release);
        }
        if (json.platforms != null) {
            builder.addAllPlatforms(json.platforms);
        }
        return builder.build();
    }

    public static ImmutableExtensionRelease copyOf(Extension.ExtensionRelease instance) {
        if (instance instanceof ImmutableExtensionRelease) {
            return (ImmutableExtensionRelease)instance;
        }
        return ImmutableExtensionRelease.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    public static final class Builder {
        private static final long INIT_BIT_RELEASE = 1L;
        private long initBits = 1L;
        private Release release;
        private List<Extension.ExtensionPlatformRelease> platforms = new ArrayList<Extension.ExtensionPlatformRelease>();

        private Builder() {
        }

        public final Builder from(ModifiableExtensionRelease instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance.releaseIsSet()) {
                this.release(instance.getRelease());
            }
            this.addAllPlatforms(instance.getPlatforms());
            return this;
        }

        public final Builder from(Extension.ExtensionRelease instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableExtensionRelease) {
                return this.from((ModifiableExtensionRelease)instance);
            }
            this.release(instance.getRelease());
            this.addAllPlatforms(instance.getPlatforms());
            return this;
        }

        @JsonProperty(value="release")
        @JsonUnwrapped
        public final Builder release(Release release) {
            this.release = Objects.requireNonNull(release, "release");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addPlatforms(Extension.ExtensionPlatformRelease element) {
            this.platforms.add(Objects.requireNonNull(element, "platforms element"));
            return this;
        }

        public final Builder addPlatforms(Extension.ExtensionPlatformRelease ... elements) {
            for (Extension.ExtensionPlatformRelease element : elements) {
                this.platforms.add(Objects.requireNonNull(element, "platforms element"));
            }
            return this;
        }

        @JsonProperty(value="platforms")
        public final Builder platforms(Iterable<? extends Extension.ExtensionPlatformRelease> elements) {
            this.platforms.clear();
            return this.addAllPlatforms(elements);
        }

        public final Builder addAllPlatforms(Iterable<? extends Extension.ExtensionPlatformRelease> elements) {
            for (Extension.ExtensionPlatformRelease extensionPlatformRelease : elements) {
                this.platforms.add(Objects.requireNonNull(extensionPlatformRelease, "platforms element"));
            }
            return this;
        }

        public ImmutableExtensionRelease build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExtensionRelease(this.release, ImmutableExtensionRelease.createUnmodifiableSet(this.platforms));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("release");
            }
            return "Cannot build ExtensionRelease, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements Extension.ExtensionRelease {
        Release release;
        Set<Extension.ExtensionPlatformRelease> platforms = Collections.emptySet();

        Json() {
        }

        @JsonProperty(value="release")
        @JsonUnwrapped
        public void setRelease(Release release) {
            this.release = release;
        }

        @JsonProperty(value="platforms")
        public void setPlatforms(Set<Extension.ExtensionPlatformRelease> platforms) {
            this.platforms = platforms;
        }

        @Override
        public Release getRelease() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Extension.ExtensionPlatformRelease> getPlatforms() {
            throw new UnsupportedOperationException();
        }
    }
}

