/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.builder;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import io.quarkus.registry.model.ImmutableRegistry;
import io.quarkus.registry.model.Registry;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class URLRegistryBuilder {
    private final List<URL> urls = new ArrayList<URL>();

    public URLRegistryBuilder addURL(URL url) {
        this.urls.add(url);
        return this;
    }

    public URLRegistryBuilder addURLs(Collection<URL> urls) {
        this.urls.addAll(urls);
        return this;
    }

    public Registry build() throws IOException {
        if (this.urls.isEmpty()) {
            throw new IllegalStateException("At least one URL must be specified");
        }
        ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setPropertyNamingStrategy(PropertyNamingStrategy.KEBAB_CASE);
        if (this.urls.size() == 1) {
            return (Registry)mapper.readValue(this.urls.get(0), Registry.class);
        }
        ImmutableRegistry.Builder builder = Registry.builder();
        for (URL url : this.urls) {
            Registry aRegistry = (Registry)mapper.readValue(url, Registry.class);
            builder.addAllCategories(aRegistry.getCategories()).addAllExtensions(aRegistry.getExtensions()).addAllPlatforms(aRegistry.getPlatforms()).putAllCoreVersions(aRegistry.getCoreVersions());
        }
        return builder.build();
    }
}

