/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.catalog.model.Extension;
import io.quarkus.registry.catalog.model.Platform;
import io.quarkus.registry.catalog.model.Repository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ImmutableRepository
extends Repository {
    private final List<Extension> individualExtensions;
    private final List<Platform> platforms;

    private ImmutableRepository(List<Extension> individualExtensions, List<Platform> platforms) {
        this.individualExtensions = individualExtensions;
        this.platforms = platforms;
    }

    @Override
    @JsonProperty(value="individualExtensions")
    public List<Extension> getIndividualExtensions() {
        return this.individualExtensions;
    }

    @Override
    @JsonProperty(value="platforms")
    public List<Platform> getPlatforms() {
        return this.platforms;
    }

    public final ImmutableRepository withIndividualExtensions(Extension ... elements) {
        List<Extension> newValue = ImmutableRepository.createUnmodifiableList(false, ImmutableRepository.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRepository(newValue, this.platforms);
    }

    public final ImmutableRepository withIndividualExtensions(Iterable<? extends Extension> elements) {
        if (this.individualExtensions == elements) {
            return this;
        }
        List<Extension> newValue = ImmutableRepository.createUnmodifiableList(false, ImmutableRepository.createSafeList(elements, true, false));
        return new ImmutableRepository(newValue, this.platforms);
    }

    public final ImmutableRepository withPlatforms(Platform ... elements) {
        List<Platform> newValue = ImmutableRepository.createUnmodifiableList(false, ImmutableRepository.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRepository(this.individualExtensions, newValue);
    }

    public final ImmutableRepository withPlatforms(Iterable<? extends Platform> elements) {
        if (this.platforms == elements) {
            return this;
        }
        List<Platform> newValue = ImmutableRepository.createUnmodifiableList(false, ImmutableRepository.createSafeList(elements, true, false));
        return new ImmutableRepository(this.individualExtensions, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepository && this.equalTo((ImmutableRepository)another);
    }

    private boolean equalTo(ImmutableRepository another) {
        return this.individualExtensions.equals(another.individualExtensions) && this.platforms.equals(another.platforms);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.individualExtensions.hashCode();
        h += (h << 5) + this.platforms.hashCode();
        return h;
    }

    public String toString() {
        return "Repository{individualExtensions=" + this.individualExtensions + ", platforms=" + this.platforms + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRepository fromJson(Json json) {
        Builder builder = ImmutableRepository.builder();
        if (json.individualExtensions != null) {
            builder.addAllIndividualExtensions(json.individualExtensions);
        }
        if (json.platforms != null) {
            builder.addAllPlatforms(json.platforms);
        }
        return builder.build();
    }

    public static ImmutableRepository copyOf(Repository instance) {
        if (instance instanceof ImmutableRepository) {
            return (ImmutableRepository)instance;
        }
        return ImmutableRepository.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<Extension> individualExtensions = new ArrayList<Extension>();
        private List<Platform> platforms = new ArrayList<Platform>();

        private Builder() {
        }

        public final Builder from(Repository instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllIndividualExtensions(instance.getIndividualExtensions());
            this.addAllPlatforms(instance.getPlatforms());
            return this;
        }

        public final Builder addIndividualExtensions(Extension element) {
            this.individualExtensions.add(Objects.requireNonNull(element, "individualExtensions element"));
            return this;
        }

        public final Builder addIndividualExtensions(Extension ... elements) {
            for (Extension element : elements) {
                this.individualExtensions.add(Objects.requireNonNull(element, "individualExtensions element"));
            }
            return this;
        }

        @JsonProperty(value="individualExtensions")
        public final Builder individualExtensions(Iterable<? extends Extension> elements) {
            this.individualExtensions.clear();
            return this.addAllIndividualExtensions(elements);
        }

        public final Builder addAllIndividualExtensions(Iterable<? extends Extension> elements) {
            for (Extension extension : elements) {
                this.individualExtensions.add(Objects.requireNonNull(extension, "individualExtensions element"));
            }
            return this;
        }

        public final Builder addPlatforms(Platform element) {
            this.platforms.add(Objects.requireNonNull(element, "platforms element"));
            return this;
        }

        public final Builder addPlatforms(Platform ... elements) {
            for (Platform element : elements) {
                this.platforms.add(Objects.requireNonNull(element, "platforms element"));
            }
            return this;
        }

        @JsonProperty(value="platforms")
        public final Builder platforms(Iterable<? extends Platform> elements) {
            this.platforms.clear();
            return this.addAllPlatforms(elements);
        }

        public final Builder addAllPlatforms(Iterable<? extends Platform> elements) {
            for (Platform platform : elements) {
                this.platforms.add(Objects.requireNonNull(platform, "platforms element"));
            }
            return this;
        }

        public ImmutableRepository build() {
            return new ImmutableRepository(ImmutableRepository.createUnmodifiableList(true, this.individualExtensions), ImmutableRepository.createUnmodifiableList(true, this.platforms));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends Repository {
        List<Extension> individualExtensions = Collections.emptyList();
        List<Platform> platforms = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="individualExtensions")
        public void setIndividualExtensions(List<Extension> individualExtensions) {
            this.individualExtensions = individualExtensions;
        }

        @JsonProperty(value="platforms")
        public void setPlatforms(List<Platform> platforms) {
            this.platforms = platforms;
        }

        @Override
        public List<Extension> getIndividualExtensions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Platform> getPlatforms() {
            throw new UnsupportedOperationException();
        }
    }
}

