/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry;

import io.quarkus.registry.DefaultExtensionRegistry;
import io.quarkus.registry.model.Extension;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableExtensionReleaseTuple
implements DefaultExtensionRegistry.ExtensionReleaseTuple {
    private final Extension extension;
    private final Extension.ExtensionRelease release;

    private ImmutableExtensionReleaseTuple(Extension extension, Extension.ExtensionRelease release) {
        this.extension = extension;
        this.release = release;
    }

    @Override
    public Extension getExtension() {
        return this.extension;
    }

    @Override
    public Extension.ExtensionRelease getRelease() {
        return this.release;
    }

    public final ImmutableExtensionReleaseTuple withExtension(Extension value) {
        if (this.extension == value) {
            return this;
        }
        Extension newValue = Objects.requireNonNull(value, "extension");
        return new ImmutableExtensionReleaseTuple(newValue, this.release);
    }

    public final ImmutableExtensionReleaseTuple withRelease(Extension.ExtensionRelease value) {
        if (this.release == value) {
            return this;
        }
        Extension.ExtensionRelease newValue = Objects.requireNonNull(value, "release");
        return new ImmutableExtensionReleaseTuple(this.extension, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExtensionReleaseTuple && this.equalTo((ImmutableExtensionReleaseTuple)another);
    }

    private boolean equalTo(ImmutableExtensionReleaseTuple another) {
        return this.extension.equals(another.extension) && this.release.equals(another.release);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.extension.hashCode();
        h += (h << 5) + this.release.hashCode();
        return h;
    }

    public String toString() {
        return "ExtensionReleaseTuple{extension=" + this.extension + ", release=" + this.release + "}";
    }

    static ImmutableExtensionReleaseTuple copyOf(DefaultExtensionRegistry.ExtensionReleaseTuple instance) {
        if (instance instanceof ImmutableExtensionReleaseTuple) {
            return (ImmutableExtensionReleaseTuple)instance;
        }
        return ImmutableExtensionReleaseTuple.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EXTENSION = 1L;
        private static final long INIT_BIT_RELEASE = 2L;
        private long initBits = 3L;
        private Extension extension;
        private Extension.ExtensionRelease release;

        private Builder() {
        }

        public final Builder from(ImmutableExtensionReleaseTuple instance) {
            return this.from((DefaultExtensionRegistry.ExtensionReleaseTuple)instance);
        }

        final Builder from(DefaultExtensionRegistry.ExtensionReleaseTuple instance) {
            Objects.requireNonNull(instance, "instance");
            this.extension(instance.getExtension());
            this.release(instance.getRelease());
            return this;
        }

        public final Builder extension(Extension extension) {
            this.extension = Objects.requireNonNull(extension, "extension");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder release(Extension.ExtensionRelease release) {
            this.release = Objects.requireNonNull(release, "release");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableExtensionReleaseTuple build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExtensionReleaseTuple(this.extension, this.release);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("extension");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("release");
            }
            return "Cannot build ExtensionReleaseTuple, some of required attributes are not set " + attributes;
        }
    }
}

