/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.jbang;

import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartProjectInput;
import io.quarkus.devtools.codestarts.CodestartResourceLoader;
import io.quarkus.devtools.codestarts.DataKey;
import io.quarkus.devtools.codestarts.core.GenericCodestartCatalog;
import io.quarkus.devtools.codestarts.jbang.QuarkusJBangCodestartProjectInput;
import io.quarkus.devtools.project.CodestartResourceLoadersBuilder;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class QuarkusJBangCodestartCatalog
extends GenericCodestartCatalog<QuarkusJBangCodestartProjectInput> {
    public static final String QUARKUS_JBANG_CODESTARTS_DIR = "codestarts/quarkus-jbang";

    private QuarkusJBangCodestartCatalog(Collection<Codestart> codestarts) {
        super(codestarts);
    }

    public static QuarkusJBangCodestartCatalog fromBaseCodestartsResources() throws IOException {
        Map<String, Codestart> codestarts = CodestartResourceLoader.loadCodestartsFromResources(CodestartResourceLoadersBuilder.getCodestartResourceLoaders(), QUARKUS_JBANG_CODESTARTS_DIR);
        return new QuarkusJBangCodestartCatalog(codestarts.values());
    }

    public static QuarkusJBangCodestartCatalog fromResourceLoaders(List<ResourceLoader> resourceLoaders) throws IOException {
        Map<String, Codestart> codestarts = CodestartResourceLoader.loadCodestartsFromResources(resourceLoaders, QUARKUS_JBANG_CODESTARTS_DIR);
        return new QuarkusJBangCodestartCatalog(codestarts.values());
    }

    protected Collection<Codestart> select(QuarkusJBangCodestartProjectInput projectInput) {
        if (projectInput.getSelection().getNames().isEmpty()) {
            if (projectInput.getDependencies().stream().anyMatch(s -> s.contains("picocli"))) {
                projectInput.getSelection().addName(ExampleCodestart.PICOCLI.key());
            } else {
                projectInput.getSelection().addName(ExampleCodestart.RESTEASY.key());
            }
        }
        projectInput.getSelection().addNames(this.getToolingCodestarts(projectInput));
        return super.select((CodestartProjectInput)projectInput);
    }

    private List<String> getToolingCodestarts(QuarkusJBangCodestartProjectInput projectInput) {
        ArrayList<String> codestarts = new ArrayList<String>();
        if (!projectInput.noJBangWrapper()) {
            codestarts.add(ToolingCodestart.JBANG_WRAPPER.key());
        }
        return codestarts;
    }

    public static enum ToolingCodestart implements DataKey
    {
        JBANG_WRAPPER;

    }

    public static enum ExampleCodestart implements DataKey
    {
        PICOCLI,
        RESTEASY;

    }

    public static enum JBangDataKey implements DataKey
    {
        QUARKUS_BOM_GROUP_ID("quarkus.bom.group-id"),
        QUARKUS_BOM_ARTIFACT_ID("quarkus.bom.artifact-id"),
        QUARKUS_BOM_VERSION("quarkus.bom.version");

        private final String key;

        private JBangDataKey(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }
}

