/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.catalog.processor;

import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import io.quarkus.platform.catalog.processor.MetadataValue;
import io.quarkus.platform.catalog.processor.ProcessedCategory;
import io.quarkus.registry.catalog.Category;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.json.JsonCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class CatalogProcessor {
    private static final String CODESTART_ARTIFACTS = "codestarts-artifacts";
    private static final Category UNCATEGORIZED_CATEGORY;
    private final ExtensionCatalog catalog;

    private CatalogProcessor(ExtensionCatalog catalog) {
        this.catalog = Objects.requireNonNull(catalog);
    }

    public static CatalogProcessor of(ExtensionCatalog catalog) {
        return new CatalogProcessor(catalog);
    }

    public static List<ProcessedCategory> getProcessedCategoriesInOrder(ExtensionCatalog catalog) {
        HashMap extsByCategory = new HashMap(catalog.getCategories().size());
        for (Extension e : catalog.getExtensions()) {
            ArrayList<String> categories = new ArrayList<String>(ExtensionProcessor.of(e).getCategories());
            if (ExtensionProcessor.isUnlisted(e)) continue;
            if (categories.isEmpty()) {
                categories.add(UNCATEGORIZED_CATEGORY.getId());
            }
            for (String c2 : categories) {
                if (!extsByCategory.containsKey(c2)) {
                    extsByCategory.put(c2, new ArrayList());
                }
                ((List)extsByCategory.get(c2)).add(e);
            }
        }
        ArrayList<ProcessedCategory> orderedCategories = new ArrayList<ProcessedCategory>(catalog.getCategories().size());
        ArrayList<Category> categories = new ArrayList<Category>(catalog.getCategories());
        if (categories.stream().noneMatch(c -> Objects.equals(c.getId(), UNCATEGORIZED_CATEGORY.getId()))) {
            categories.add(UNCATEGORIZED_CATEGORY);
        }
        for (Category c3 : categories) {
            if (!extsByCategory.containsKey(c3.getId())) continue;
            orderedCategories.add(new ProcessedCategory(c3, (Collection)extsByCategory.get(c3.getId())));
        }
        return orderedCategories;
    }

    public static List<String> getCodestartArtifacts(ExtensionCatalog catalog) {
        return CatalogProcessor.getMetadataValue(catalog, CODESTART_ARTIFACTS).asStringList();
    }

    public ExtensionCatalog getCatalog() {
        return this.catalog;
    }

    public List<String> getCodestartArtifacts() {
        return CatalogProcessor.getCodestartArtifacts(this.catalog);
    }

    public List<ProcessedCategory> getProcessedCategoriesInOrder() {
        return CatalogProcessor.getProcessedCategoriesInOrder(this.catalog);
    }

    public static MetadataValue getMetadataValue(ExtensionCatalog catalog, String path) {
        return MetadataValue.get(catalog.getMetadata(), path);
    }

    static {
        JsonCategory uncategorized = new JsonCategory();
        uncategorized.setId("uncategorized");
        uncategorized.setName("Uncategorized");
        uncategorized.setDescription("The category is not defined for those extensions.");
        UNCATEGORIZED_CATEGORY = uncategorized;
    }
}

