/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.buildfile.AbstractGradleBuildFile;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;

abstract class AbstractGradleBuildFilesCreator {
    private static final String GRADLE_PROPERTIES_PATH = "gradle.properties";
    private final QuarkusProject quarkusProject;
    private AtomicReference<AbstractGradleBuildFile.Model> modelReference = new AtomicReference();

    public AbstractGradleBuildFilesCreator(QuarkusProject quarkusProject) {
        this.quarkusProject = quarkusProject;
    }

    abstract String getSettingsGradlePath();

    abstract String getBuildGradlePath();

    abstract void createBuildContent(String var1, String var2) throws IOException;

    abstract void createSettingsContent(String var1) throws IOException;

    abstract void addDependencyInBuildFile(ArtifactCoords var1) throws IOException;

    public void create(String groupId, String artifactId, String version, Properties properties, List<ArtifactCoords> extensions) throws IOException {
        this.createSettingsContent(artifactId);
        this.createBuildContent(groupId, version);
        this.createProperties();
        extensions.forEach(e -> {
            try {
                this.addDependencyInBuildFile((ArtifactCoords)e);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
        this.writeToDisk();
    }

    private void writeToDisk() throws IOException {
        this.writeToProjectFile(this.getSettingsGradlePath(), this.getModel().getSettingsContent().getBytes());
        this.writeToProjectFile(this.getBuildGradlePath(), this.getModel().getBuildContent().getBytes());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.getModel().getPropertiesContent().store(out, "Gradle properties");
            this.writeToProjectFile(GRADLE_PROPERTIES_PATH, out.toByteArray());
        }
    }

    protected boolean containsBOM(String groupId, String artifactId) throws IOException {
        String buildContent = this.getModel().getBuildContent();
        return buildContent.contains("enforcedPlatform(\"${quarkusPlatformGroupId}:${quarkusPlatformArtifactId}:") || buildContent.contains("enforcedPlatform(\"" + groupId + ":" + artifactId + ":");
    }

    public String getProperty(String propertyName) throws IOException {
        return this.getModel().getPropertiesContent().getProperty(propertyName);
    }

    QuarkusProject getQuarkusProject() {
        return this.quarkusProject;
    }

    AbstractGradleBuildFile.Model getModel() throws IOException {
        return this.modelReference.updateAndGet(model -> {
            if (model == null) {
                try {
                    return this.readModel();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return model;
        });
    }

    private AbstractGradleBuildFile.Model readModel() throws IOException {
        String settingsContent = "";
        String buildContent = "";
        Properties propertiesContent = new Properties();
        if (this.hasProjectFile(this.getSettingsGradlePath())) {
            byte[] settings = this.readProjectFile(this.getSettingsGradlePath());
            settingsContent = new String(settings, StandardCharsets.UTF_8);
        }
        if (this.hasProjectFile(this.getBuildGradlePath())) {
            byte[] build = this.readProjectFile(this.getBuildGradlePath());
            buildContent = new String(build, StandardCharsets.UTF_8);
        }
        if (this.hasProjectFile(GRADLE_PROPERTIES_PATH)) {
            byte[] properties = this.readProjectFile(GRADLE_PROPERTIES_PATH);
            propertiesContent.load(new ByteArrayInputStream(properties));
        }
        return new AbstractGradleBuildFile.Model(settingsContent, buildContent, propertiesContent, null, null);
    }

    protected boolean hasProjectFile(String fileName) throws IOException {
        Path filePath = this.quarkusProject.getProjectDirPath().resolve(fileName);
        return Files.exists(filePath, new LinkOption[0]);
    }

    protected byte[] readProjectFile(String fileName) throws IOException {
        Path filePath = this.quarkusProject.getProjectDirPath().resolve(fileName);
        return Files.readAllBytes(filePath);
    }

    protected void writeToProjectFile(String fileName, byte[] content) throws IOException {
        Files.write(this.quarkusProject.getProjectDirPath().resolve(fileName), content, new OpenOption[0]);
    }

    private void createProperties() throws IOException {
        ExtensionCatalog platform = this.quarkusProject.getExtensionsCatalog();
        Properties props = this.getModel().getPropertiesContent();
        if (props.getProperty("quarkusPluginVersion") == null) {
            props.setProperty("quarkusPluginVersion", ToolsUtils.getGradlePluginVersion(ToolsUtils.readQuarkusProperties(platform)));
        }
        ArtifactCoords bom = platform.getBom();
        if (props.getProperty("quarkusPlatformGroupId") == null) {
            props.setProperty("quarkusPlatformGroupId", bom.getGroupId());
        }
        if (props.getProperty("quarkusPlatformArtifactId") == null) {
            props.setProperty("quarkusPlatformArtifactId", bom.getArtifactId());
        }
        if (props.getProperty("quarkusPlatformVersion") == null) {
            props.setProperty("quarkusPlatformVersion", bom.getVersion());
        }
    }
}

