/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry;

import io.quarkus.registry.union.UnionVersion;

public class PlatformStackIndex
implements UnionVersion {
    private final int platformPriority;
    private final int streamPriority;
    private final int releasePriority;

    public static PlatformStackIndex initial() {
        return new PlatformStackIndex(0, 0, 0);
    }

    PlatformStackIndex(int platformPriority, int streamPriority, int releasePriority) {
        this.platformPriority = platformPriority;
        this.streamPriority = streamPriority;
        this.releasePriority = releasePriority;
    }

    @Override
    public int compareTo(UnionVersion o) {
        if (!(o instanceof PlatformStackIndex)) {
            return 0;
        }
        PlatformStackIndex other = (PlatformStackIndex)o;
        if (this.platformPriority > other.platformPriority) {
            return 1;
        }
        if (this.platformPriority < other.platformPriority) {
            return -1;
        }
        if (this.streamPriority > other.streamPriority) {
            return 1;
        }
        if (this.streamPriority < other.streamPriority) {
            return -1;
        }
        if (this.releasePriority > other.releasePriority) {
            return 1;
        }
        if (this.releasePriority < other.releasePriority) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.platformPriority;
        result = 31 * result + this.releasePriority;
        result = 31 * result + this.streamPriority;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlatformStackIndex other = (PlatformStackIndex)obj;
        if (this.platformPriority != other.platformPriority) {
            return false;
        }
        if (this.releasePriority != other.releasePriority) {
            return false;
        }
        return this.streamPriority == other.streamPriority;
    }

    public String toString() {
        return this.platformPriority + "." + this.streamPriority + "." + this.releasePriority;
    }
}

