/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.client.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.client.RegistryClient;
import io.quarkus.registry.client.RegistryClientDispatcher;
import io.quarkus.registry.client.RegistryClientFactory;
import io.quarkus.registry.client.maven.MavenNonPlatformExtensionsResolver;
import io.quarkus.registry.client.maven.MavenPlatformExtensionsResolver;
import io.quarkus.registry.client.maven.MavenPlatformsResolver;
import io.quarkus.registry.client.maven.MavenRegistryArtifactResolver;
import io.quarkus.registry.client.maven.MavenRegistryArtifactResolverWithCleanup;
import io.quarkus.registry.client.maven.MavenRegistryCache;
import io.quarkus.registry.config.RegistryArtifactConfig;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.config.RegistryDescriptorConfig;
import io.quarkus.registry.config.RegistryMavenConfig;
import io.quarkus.registry.config.RegistryMavenRepoConfig;
import io.quarkus.registry.config.RegistryNonPlatformExtensionsConfig;
import io.quarkus.registry.config.RegistryPlatformsConfig;
import io.quarkus.registry.config.json.JsonRegistryConfig;
import io.quarkus.registry.config.json.JsonRegistryMavenConfig;
import io.quarkus.registry.config.json.JsonRegistryMavenRepoConfig;
import io.quarkus.registry.config.json.JsonRegistryPlatformsConfig;
import io.quarkus.registry.config.json.RegistriesConfigMapperHelper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;

public class MavenRegistryClientFactory
implements RegistryClientFactory {
    private static final String CLEANUP_TIMESTAMPED_ARTIFACTS = "cleanup-timestamped-artifacts";
    private MessageWriter log;
    private MavenArtifactResolver originalResolver;

    public MavenRegistryClientFactory(MavenArtifactResolver resolver, MessageWriter log) {
        this.originalResolver = Objects.requireNonNull(resolver);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public RegistryClient buildRegistryClient(RegistryConfig config) throws RegistryResolutionException {
        MavenPlatformsResolver platformsResolver;
        MavenNonPlatformExtensionsResolver nonPlatformExtensionsResolver;
        RegistryConfig descriptor;
        ArtifactResult result;
        MavenArtifactResolver resolver;
        Objects.requireNonNull(config, "The registry config is null");
        RegistryDescriptorConfig descriptorConfig = config.getDescriptor();
        if (descriptorConfig == null) {
            throw new IllegalArgumentException("The registry descriptor configuration is missing for " + config.getId());
        }
        ArtifactCoords originalDescrCoords = descriptorConfig.getArtifact();
        DefaultArtifact registryDescriptorCoords = new DefaultArtifact(originalDescrCoords.getGroupId(), originalDescrCoords.getArtifactId(), originalDescrCoords.getClassifier(), originalDescrCoords.getType(), originalDescrCoords.getVersion());
        boolean cleanupTimestampedArtifacts = MavenRegistryClientFactory.isCleanupTimestampedArtifacts(config);
        List<RemoteRepository> registryRepos = this.determineRegistryRepos(config, this.originalResolver.getRepositories());
        if (!registryRepos.isEmpty()) {
            List aggregatedRepos = this.originalResolver.getRemoteRepositoryManager().aggregateRepositories(this.originalResolver.getSession(), Collections.emptyList(), registryRepos, true);
            resolver = MavenRegistryClientFactory.newResolver(this.originalResolver, aggregatedRepos, config, this.log);
            try {
                result = MavenRegistryArtifactResolverWithCleanup.resolveAndCleanupOldTimestampedVersions(resolver, (Artifact)registryDescriptorCoords, cleanupTimestampedArtifacts);
            }
            catch (BootstrapMavenException e) {
                if (MavenRegistryClientFactory.areMatching(registryRepos, aggregatedRepos)) {
                    throw new RegistryResolutionException(MavenRegistryClientFactory.getDescriptorResolutionFailureMessage(config, resolver, e), e);
                }
                this.log.warn(MavenRegistryClientFactory.getDescriptorResolutionFailureFromMirrorMessage(config, resolver, e, registryRepos));
                resolver = MavenRegistryClientFactory.newResolver(this.originalResolver, registryRepos, config, this.log);
                try {
                    result = MavenRegistryArtifactResolverWithCleanup.resolveAndCleanupOldTimestampedVersions(resolver, (Artifact)registryDescriptorCoords, cleanupTimestampedArtifacts);
                }
                catch (BootstrapMavenException e1) {
                    throw new RegistryResolutionException(MavenRegistryClientFactory.getDescriptorResolutionFailureMessage(config, resolver, e));
                }
            }
        } else {
            resolver = MavenRegistryClientFactory.newResolver(this.originalResolver, this.originalResolver.getRepositories(), config, this.log);
            try {
                result = MavenRegistryArtifactResolverWithCleanup.resolveAndCleanupOldTimestampedVersions(resolver, (Artifact)registryDescriptorCoords, cleanupTimestampedArtifacts);
            }
            catch (BootstrapMavenException e) {
                throw new RegistryResolutionException(MavenRegistryClientFactory.getDescriptorResolutionFailureMessage(config, resolver, e));
            }
        }
        String srcRepoId = result.getRepository() == null ? "n/a" : result.getRepository().getId();
        this.log.debug("Resolved registry descriptor %s from %s", new Object[]{registryDescriptorCoords, srcRepoId});
        if (!registryRepos.isEmpty()) {
            if (srcRepoId != null && !"local".equals(srcRepoId)) {
                String srcRepoUrl = null;
                for (RemoteRepository repo : resolver.getRepositories()) {
                    if (!repo.getId().equals(srcRepoId)) continue;
                    srcRepoUrl = repo.getUrl();
                    break;
                }
                if (srcRepoUrl == null) {
                    throw new IllegalStateException("Failed to locate the repository URL corresponding to repository " + srcRepoId);
                }
            } else {
                this.log.debug("Failed to determine the remote repository for %s registry descriptor %s", new Object[]{config.getId(), registryDescriptorCoords});
            }
        }
        try {
            descriptor = RegistriesConfigMapperHelper.deserialize(result.getArtifact().getFile().toPath(), JsonRegistryConfig.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to deserialize registries descriptor " + result.getArtifact().getFile(), e);
        }
        if (!MavenRegistryClientFactory.isComplete(config, descriptor)) {
            JsonRegistryConfig complete = new JsonRegistryConfig();
            MavenRegistryClientFactory.complete(complete, config, descriptor);
            config = complete;
        }
        MavenRegistryArtifactResolver defaultResolver = MavenRegistryClientFactory.defaultResolver(resolver, cleanupTimestampedArtifacts);
        RegistryNonPlatformExtensionsConfig nonPlatformExtensions = config.getNonPlatformExtensions();
        if (nonPlatformExtensions == null || nonPlatformExtensions.isDisabled()) {
            this.log.debug("Non-platform extension catalogs were disabled for registry %s", new Object[]{config.getId()});
            nonPlatformExtensionsResolver = null;
        } else {
            nonPlatformExtensionsResolver = new MavenNonPlatformExtensionsResolver(nonPlatformExtensions, defaultResolver, this.log);
        }
        RegistryPlatformsConfig platformsConfig = config.getPlatforms();
        if (platformsConfig == null || platformsConfig.isDisabled()) {
            this.log.debug("Platform catalogs were disabled for registry %s", new Object[]{config.getId()});
            platformsResolver = null;
        } else {
            platformsResolver = new MavenPlatformsResolver(platformsConfig, defaultResolver, this.log);
        }
        return new RegistryClientDispatcher(config, platformsResolver, Boolean.TRUE.equals(platformsConfig == null ? Boolean.FALSE : platformsConfig.getExtensionCatalogsIncluded()) ? new MavenPlatformExtensionsResolver(defaultResolver, this.log) : new MavenPlatformExtensionsResolver(MavenRegistryClientFactory.defaultResolver(this.originalResolver, cleanupTimestampedArtifacts), this.log), nonPlatformExtensionsResolver, new MavenRegistryCache(config, defaultResolver, this.log));
    }

    private static boolean isCleanupTimestampedArtifacts(RegistryConfig config) {
        Object o = config.getExtra().get(CLEANUP_TIMESTAMPED_ARTIFACTS);
        return o == null ? true : Boolean.parseBoolean(o.toString());
    }

    private static MavenRegistryArtifactResolver defaultResolver(MavenArtifactResolver resolver, boolean cleanupTimestampedArtifacts) {
        return new MavenRegistryArtifactResolverWithCleanup(resolver, cleanupTimestampedArtifacts);
    }

    private static void complete(JsonRegistryConfig complete, RegistryConfig original, RegistryConfig descriptor) {
        complete.setId(original.getId() == null ? descriptor.getId() : original.getId());
        if (original.getDescriptor() == null) {
            complete.setDescriptor(descriptor.getDescriptor());
        } else {
            complete.setDescriptor(original.getDescriptor());
        }
        if (original.getPlatforms() == null) {
            complete.setPlatforms(descriptor.getPlatforms());
        } else {
            complete.setPlatforms(MavenRegistryClientFactory.complete(original.getPlatforms(), descriptor.getPlatforms()));
        }
        if (original.getNonPlatformExtensions() == null) {
            complete.setNonPlatformExtensions(descriptor.getNonPlatformExtensions());
        } else {
            complete.setNonPlatformExtensions(original.getNonPlatformExtensions());
        }
        if (original.getUpdatePolicy() == null) {
            complete.setUpdatePolicy(descriptor.getUpdatePolicy());
        } else {
            complete.setUpdatePolicy(original.getUpdatePolicy());
        }
        if (original.getMaven() == null) {
            complete.setMaven(descriptor.getMaven());
        } else if (MavenRegistryClientFactory.isComplete(original.getMaven())) {
            complete.setMaven(original.getMaven());
        } else {
            JsonRegistryMavenConfig completeMavenConfig = new JsonRegistryMavenConfig();
            complete.setMaven(completeMavenConfig);
            MavenRegistryClientFactory.complete(completeMavenConfig, original.getMaven(), descriptor.getMaven() == null ? completeMavenConfig : descriptor.getMaven());
        }
        if (original.getQuarkusVersions() == null) {
            complete.setQuarkusVersions(descriptor.getQuarkusVersions());
        }
    }

    private static RegistryPlatformsConfig complete(RegistryPlatformsConfig client, RegistryPlatformsConfig descriptor) {
        if (client == null) {
            return descriptor;
        }
        if (MavenRegistryClientFactory.isComplete(client)) {
            return client;
        }
        JsonRegistryPlatformsConfig complete = new JsonRegistryPlatformsConfig();
        complete.setArtifact(client.getArtifact() == null ? descriptor.getArtifact() : client.getArtifact());
        complete.setDisabled(client.isDisabled());
        complete.setExtensionCatalogsIncluded(client.getExtensionCatalogsIncluded() == null ? descriptor.getExtensionCatalogsIncluded() : client.getExtensionCatalogsIncluded());
        return complete;
    }

    private static void complete(JsonRegistryMavenConfig complete, RegistryMavenConfig original, RegistryMavenConfig descriptor) {
        if (original.getRepository() == null) {
            complete.setRepository(descriptor.getRepository());
        } else if (MavenRegistryClientFactory.isComplete(original.getRepository()) || descriptor.getRepository() == null) {
            complete.setRepository(original.getRepository());
        } else {
            JsonRegistryMavenRepoConfig completeRepo = new JsonRegistryMavenRepoConfig();
            complete.setRepository(completeRepo);
            MavenRegistryClientFactory.complete(completeRepo, original.getRepository(), descriptor.getRepository());
        }
    }

    private static void complete(JsonRegistryMavenRepoConfig complete, RegistryMavenRepoConfig original, RegistryMavenRepoConfig descriptor) {
        complete.setId(original.getId() == null ? descriptor.getId() : original.getId());
        complete.setUrl(original.getUrl() == null ? descriptor.getUrl() : original.getUrl());
    }

    private static boolean isComplete(RegistryConfig client, RegistryConfig descriptor) {
        if (!client.isEnabled()) {
            return true;
        }
        if (client.getDescriptor() == null) {
            return false;
        }
        if (!MavenRegistryClientFactory.isComplete(client.getPlatforms(), descriptor.getPlatforms())) {
            return false;
        }
        if (!MavenRegistryClientFactory.isComplete(client.getNonPlatformExtensions())) {
            return false;
        }
        if (!MavenRegistryClientFactory.isComplete(client.getMaven())) {
            return false;
        }
        if (client.getQuarkusVersions() == null && descriptor.getQuarkusVersions() != null) {
            return false;
        }
        return client.getUpdatePolicy() != null || descriptor.getUpdatePolicy() == null;
    }

    private static boolean isComplete(RegistryMavenConfig config) {
        if (config == null) {
            return false;
        }
        return MavenRegistryClientFactory.isComplete(config.getRepository());
    }

    private static boolean isComplete(RegistryPlatformsConfig client, RegistryPlatformsConfig descriptor) {
        if (!MavenRegistryClientFactory.isComplete(client)) {
            return false;
        }
        return descriptor == null || !Boolean.TRUE.equals(descriptor.getExtensionCatalogsIncluded()) || client.getExtensionCatalogsIncluded() != null;
    }

    private static boolean isComplete(RegistryArtifactConfig config) {
        if (config == null) {
            return false;
        }
        return config.isDisabled() || config.getArtifact() != null;
    }

    private static boolean isComplete(RegistryMavenRepoConfig config) {
        if (config == null) {
            return false;
        }
        if (config.getId() == null) {
            return false;
        }
        return config.getUrl() != null;
    }

    private static MavenArtifactResolver newResolver(MavenArtifactResolver resolver, List<RemoteRepository> aggregatedRepos, RegistryConfig config, MessageWriter log) {
        try {
            BootstrapMavenContext mvnCtx = new BootstrapMavenContext(BootstrapMavenContext.config().setRepositorySystem(resolver.getSystem()).setRepositorySystemSession((RepositorySystemSession)MavenRegistryClientFactory.setRegistryTransferListener(config, log, resolver.getSession())).setRemoteRepositoryManager(resolver.getRemoteRepositoryManager()).setRemoteRepositories(aggregatedRepos).setLocalRepository(resolver.getMavenContext().getLocalRepo()).setCurrentProject(resolver.getMavenContext().getCurrentProject()));
            return new MavenArtifactResolver(mvnCtx);
        }
        catch (BootstrapMavenException e) {
            throw new IllegalStateException("Failed to initialize Maven context", e);
        }
    }

    private static DefaultRepositorySystemSession setRegistryTransferListener(final RegistryConfig config, final MessageWriter log, RepositorySystemSession session) {
        DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(session);
        final TransferListener tl = newSession.getTransferListener();
        newSession.setTransferListener(new TransferListener(){
            boolean loggedCatalogRefreshMsg;

            public void transferInitiated(TransferEvent event) throws TransferCancelledException {
                if (!this.loggedCatalogRefreshMsg && !event.getResource().getResourceName().contains(config.getDescriptor().getArtifact().getArtifactId())) {
                    this.loggedCatalogRefreshMsg = true;
                    log.info("Looking for the newly published extensions in " + config.getId());
                }
                if (tl != null) {
                    tl.transferInitiated(event);
                }
            }

            public void transferStarted(TransferEvent event) throws TransferCancelledException {
                if (tl != null) {
                    tl.transferStarted(event);
                }
            }

            public void transferProgressed(TransferEvent event) throws TransferCancelledException {
                if (tl != null) {
                    tl.transferProgressed(event);
                }
            }

            public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
                if (tl != null) {
                    tl.transferCorrupted(event);
                }
            }

            public void transferSucceeded(TransferEvent event) {
                if (tl != null) {
                    tl.transferSucceeded(event);
                }
            }

            public void transferFailed(TransferEvent event) {
                if (tl != null) {
                    tl.transferFailed(event);
                }
            }
        });
        return newSession;
    }

    private List<RemoteRepository> determineRegistryRepos(RegistryConfig config, List<RemoteRepository> configuredRepos) {
        String repoUrl;
        RegistryMavenConfig mavenConfig = config.getMaven() == null ? null : config.getMaven();
        RegistryMavenRepoConfig repoConfig = mavenConfig == null ? null : mavenConfig.getRepository();
        String repoId = repoConfig == null || repoConfig.getId() == null ? config.getId() : repoConfig.getId();
        String string = repoUrl = repoConfig == null ? null : repoConfig.getUrl();
        if (repoUrl == null || repoUrl.isBlank()) {
            for (RemoteRepository r : configuredRepos) {
                if (!r.getId().equals(repoId)) continue;
                return Collections.emptyList();
            }
            try {
                repoUrl = new URL("https", config.getId(), "/maven").toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Failed to derive the Maven repository URL for registry " + config.getId(), e);
            }
        } else {
            for (RemoteRepository repo : configuredRepos) {
                if (!repo.getUrl().equals(repoUrl)) continue;
                return Collections.emptyList();
            }
        }
        RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder(repoId, "default", repoUrl);
        String updatePolicy = config.getUpdatePolicy();
        if (updatePolicy != null) {
            if (updatePolicy.equalsIgnoreCase("daily") || updatePolicy.equalsIgnoreCase("always") || updatePolicy.equalsIgnoreCase("never") || updatePolicy.startsWith("interval")) {
                repoBuilder.setPolicy(new RepositoryPolicy(true, updatePolicy, "warn"));
            } else {
                throw new IllegalStateException("Unrecognized update policy '" + updatePolicy + "' for repository " + repoId);
            }
        }
        return Collections.singletonList(repoBuilder.build());
    }

    private static String getDescriptorResolutionFailureFromMirrorMessage(RegistryConfig config, MavenArtifactResolver resolver, BootstrapMavenException e, List<RemoteRepository> originalRegistryRepos) {
        StringBuilder buf = new StringBuilder();
        buf.append(MavenRegistryClientFactory.getDescriptorResolutionFailureMessage(config, resolver, e));
        buf.append(" having applied the mirrors and/or proxies from the Maven settings to ");
        MavenRegistryClientFactory.appendRepoInfo(buf, originalRegistryRepos.get(0));
        for (int i = 1; i < originalRegistryRepos.size(); ++i) {
            buf.append(", ");
            MavenRegistryClientFactory.appendRepoInfo(buf, originalRegistryRepos.get(i));
        }
        buf.append(". Re-trying with the original " + config.getId() + " repository configuration.");
        return buf.toString();
    }

    private static String getDescriptorResolutionFailureMessage(RegistryConfig config, MavenArtifactResolver resolver, BootstrapMavenException e) {
        StringWriter buf = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(buf);){
            writer.write("Failed to resolve the Quarkus extension registry descriptor of ");
            writer.write(config.getId());
            writer.write(" from ");
            List repos = resolver.getRepositories();
            MavenRegistryClientFactory.appendRepoInfo(writer, (RemoteRepository)repos.get(0));
            for (int i = 1; i < repos.size(); ++i) {
                writer.append(", ");
                MavenRegistryClientFactory.appendRepoInfo(writer, (RemoteRepository)repos.get(i));
            }
        }
        catch (IOException e1) {
            buf.append(e.getLocalizedMessage());
        }
        return buf.toString();
    }

    private static void appendRepoInfo(Appendable writer, RemoteRepository repo) {
        try {
            writer.append(repo.getId());
            writer.append(" (");
            writer.append(repo.getUrl());
            writer.append(")");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compose an error message", e);
        }
    }

    private static boolean areMatching(List<RemoteRepository> registryRepos, List<RemoteRepository> aggregatedRepos) {
        if (registryRepos.size() != aggregatedRepos.size()) {
            return false;
        }
        for (int i = 0; i < registryRepos.size(); ++i) {
            RemoteRepository original = registryRepos.get(i);
            RemoteRepository aggregated = aggregatedRepos.get(i);
            if (original.getId().equals(aggregated.getId()) && original.getUrl().equals(aggregated.getUrl())) continue;
            return false;
        }
        return true;
    }
}

