/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.runtime;

import io.quarkus.funqy.runtime.ApplicationException;
import io.quarkus.funqy.runtime.FunctionConstructor;
import io.quarkus.funqy.runtime.FunqyServerRequest;
import io.quarkus.funqy.runtime.FunqyServerResponse;
import io.quarkus.funqy.runtime.InputValueInjector;
import io.quarkus.funqy.runtime.InternalError;
import io.quarkus.funqy.runtime.ParameterInjector;
import io.quarkus.funqy.runtime.ValueInjector;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FunctionInvoker {
    protected String name;
    protected Class<?> targetClass;
    protected Method method;
    protected FunctionConstructor<?> constructor;
    protected ArrayList<ValueInjector> parameterInjectors;
    protected Type inputType;
    protected Type outputType;
    protected boolean isAsync;
    protected Map<String, Object> bindingContext = new ConcurrentHashMap<String, Object>();

    public FunctionInvoker(String name, Class<?> targetClass, Method method) {
        this.name = name;
        this.targetClass = targetClass;
        this.method = method;
        if (method.getParameterCount() > 0) {
            this.parameterInjectors = new ArrayList(method.getParameterCount());
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < method.getParameterCount(); ++i) {
                Type type = genericParameterTypes[i];
                Class<?> clz = parameterTypes[i];
                Annotation[] annotations = parameterAnnotations[i];
                ValueInjector injector = ParameterInjector.createInjector(type, clz, annotations);
                if (injector instanceof InputValueInjector) {
                    this.inputType = type;
                }
                this.parameterInjectors.add(injector);
            }
        }
        this.constructor = new FunctionConstructor(targetClass);
        Class<?> returnType = method.getReturnType();
        if (returnType != null) {
            if (Uni.class.isAssignableFrom(returnType)) {
                Type[] actualParams;
                this.outputType = null;
                this.isAsync = true;
                Type genericReturnType = method.getGenericReturnType();
                if (genericReturnType instanceof ParameterizedType && (actualParams = ((ParameterizedType)genericReturnType).getActualTypeArguments()).length == 1) {
                    this.outputType = actualParams[0];
                }
                if (this.outputType == null) {
                    throw new IllegalArgumentException("Uni must be used with type parameter (e.g. Uni<String>).");
                }
            } else {
                this.outputType = method.getGenericReturnType();
            }
        }
    }

    public Map<String, Object> getBindingContext() {
        return this.bindingContext;
    }

    public boolean hasInput() {
        return this.inputType != null;
    }

    public Type getInputType() {
        return this.inputType;
    }

    public Type getOutputType() {
        return this.outputType;
    }

    protected boolean isAsync() {
        return this.isAsync;
    }

    protected void setAsync(boolean async) {
        this.isAsync = async;
    }

    public boolean hasOutput() {
        return this.outputType != null && !this.outputType.equals(Void.TYPE) && !this.outputType.equals(Void.class);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Method getMethod() {
        return this.method;
    }

    public void invoke(FunqyServerRequest request, FunqyServerResponse response) {
        RuntimeException ex;
        Object[] args = null;
        if (this.parameterInjectors != null) {
            args = new Object[this.parameterInjectors.size()];
            int i = 0;
            for (ValueInjector injector : this.parameterInjectors) {
                args[i++] = injector.extract(request);
            }
        }
        Object target = this.constructor.construct();
        try {
            Object result = this.method.invoke(target, args);
            if (this.isAsync()) {
                response.setOutput(((Uni)result).onFailure().transform(t -> new ApplicationException((Throwable)t)));
            } else {
                response.setOutput(Uni.createFrom().item(result));
            }
        }
        catch (IllegalAccessException e) {
            ex = new InternalError("Failed to invoke function", e);
            response.setOutput(Uni.createFrom().failure((Throwable)ex));
        }
        catch (InvocationTargetException e) {
            ex = new ApplicationException(e.getCause());
            response.setOutput(Uni.createFrom().failure((Throwable)ex));
        }
        catch (Throwable t2) {
            ex = new InternalError(t2);
            response.setOutput(Uni.createFrom().failure((Throwable)ex));
        }
    }
}

