/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.component;

import io.quarkus.arc.All;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ComponentsProvider;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.Unremovable;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanArchives;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.ContextRegistrar;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorConfigurator;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.Types;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.runtime.configuration.ApplicationPropertiesConfigSourceLoader;
import io.quarkus.test.InjectMock;
import io.quarkus.test.component.ConfigBeanCreator;
import io.quarkus.test.component.ConfigMappingBeanCreator;
import io.quarkus.test.component.ConfigPropertyBeanCreator;
import io.quarkus.test.component.InterceptorMethodCreator;
import io.quarkus.test.component.JaxrsSingletonTransformer;
import io.quarkus.test.component.MockBeanConfiguratorImpl;
import io.quarkus.test.component.MockBeanCreator;
import io.quarkus.test.component.QuarkusComponentTestClassLoader;
import io.quarkus.test.component.QuarkusComponentTestConfigSource;
import io.quarkus.test.component.QuarkusComponentTestConfiguration;
import io.quarkus.test.component.QuarkusComponentTestExtensionBuilder;
import io.smallrye.common.annotation.Experimental;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

@Experimental(value="This feature is experimental and the API may change in the future")
public class QuarkusComponentTestExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
TestInstancePostProcessor {
    private static final Logger LOG = Logger.getLogger(QuarkusComponentTestExtension.class);
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{QuarkusComponentTestExtension.class});
    private static final String KEY_OLD_TCCL = "oldTccl";
    private static final String KEY_OLD_CONFIG_PROVIDER_RESOLVER = "oldConfigProviderResolver";
    private static final String KEY_GENERATED_RESOURCES = "generatedResources";
    private static final String KEY_INJECTED_FIELDS = "injectedFields";
    private static final String KEY_TEST_INSTANCE = "testInstance";
    private static final String KEY_CONFIG = "config";
    private static final String KEY_TEST_CLASS_CONFIG = "testClassConfig";
    private static final String KEY_CONFIG_MAPPINGS = "configMappings";
    private static final String QUARKUS_TEST_COMPONENT_OUTPUT_DIRECTORY = "quarkus.test.component.output-directory";
    private final QuarkusComponentTestConfiguration baseConfiguration;

    public static QuarkusComponentTestExtensionBuilder builder() {
        return new QuarkusComponentTestExtensionBuilder();
    }

    public QuarkusComponentTestExtension() {
        this(QuarkusComponentTestConfiguration.DEFAULT);
    }

    public QuarkusComponentTestExtension(Class<?> ... additionalComponentClasses) {
        this(new QuarkusComponentTestConfiguration(Map.of(), List.of(additionalComponentClasses), List.of(), false, true, 500, List.of()));
    }

    QuarkusComponentTestExtension(QuarkusComponentTestConfiguration baseConfiguration) {
        this.baseConfiguration = baseConfiguration;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        this.buildContainer(context);
        this.startContainer(context, TestInstance.Lifecycle.PER_CLASS);
        LOG.debugf("beforeAll: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public void afterAll(ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        this.stopContainer(context, TestInstance.Lifecycle.PER_CLASS);
        this.cleanup(context);
        LOG.debugf("afterAll: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        this.startContainer(context, TestInstance.Lifecycle.PER_METHOD);
        Arc.container().requestContext().activate();
        LOG.debugf("beforeEach: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public void afterEach(ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        Arc.container().requestContext().terminate();
        this.stopContainer(context, TestInstance.Lifecycle.PER_METHOD);
        LOG.debugf("afterEach: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        long start = System.nanoTime();
        context.getRoot().getStore(NAMESPACE).put((Object)KEY_TEST_INSTANCE, testInstance);
        LOG.debugf("postProcessTestInstance: %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    private void buildContainer(ExtensionContext context) {
        QuarkusComponentTestConfiguration testClassConfiguration = this.baseConfiguration.update(context.getRequiredTestClass());
        context.getRoot().getStore(NAMESPACE).put((Object)KEY_TEST_CLASS_CONFIG, (Object)testClassConfiguration);
        ClassLoader oldTccl = this.initArcContainer(context, testClassConfiguration);
        context.getRoot().getStore(NAMESPACE).put((Object)KEY_OLD_TCCL, (Object)oldTccl);
    }

    private void cleanup(ExtensionContext context) {
        ClassLoader oldTccl = (ClassLoader)context.getRoot().getStore(NAMESPACE).get((Object)KEY_OLD_TCCL, ClassLoader.class);
        Thread.currentThread().setContextClassLoader(oldTccl);
        context.getRoot().getStore(NAMESPACE).remove((Object)KEY_CONFIG_MAPPINGS);
        Set generatedResources = (Set)context.getRoot().getStore(NAMESPACE).get((Object)KEY_GENERATED_RESOURCES, Set.class);
        for (Path path : generatedResources) {
            try {
                LOG.debugf("Delete generated %s", (Object)path);
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                LOG.errorf("Unable to delete the generated resource %s: ", (Object)path, (Object)e.getMessage());
            }
        }
    }

    private void stopContainer(ExtensionContext context, TestInstance.Lifecycle testInstanceLifecycle) throws Exception {
        if (testInstanceLifecycle.equals((Object)context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD))) {
            for (FieldInjector fieldInjector : (List)context.getRoot().getStore(NAMESPACE).get((Object)KEY_INJECTED_FIELDS, List.class)) {
                fieldInjector.unset(context.getRequiredTestInstance());
            }
            try {
                Arc.shutdown();
            }
            catch (Exception e) {
                LOG.error((Object)("An error occured during ArC shutdown: " + e));
            }
            MockBeanCreator.clear();
            ConfigBeanCreator.clear();
            InterceptorMethodCreator.clear();
            SmallRyeConfig config = (SmallRyeConfig)context.getRoot().getStore(NAMESPACE).get((Object)KEY_CONFIG, SmallRyeConfig.class);
            ConfigProviderResolver.instance().releaseConfig((Config)config);
            ConfigProviderResolver.setInstance((ConfigProviderResolver)((ConfigProviderResolver)context.getRoot().getStore(NAMESPACE).get((Object)KEY_OLD_CONFIG_PROVIDER_RESOLVER, ConfigProviderResolver.class)));
        }
    }

    private void startContainer(ExtensionContext context, TestInstance.Lifecycle testInstanceLifecycle) throws Exception {
        if (testInstanceLifecycle.equals((Object)context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD))) {
            Arc.initialize();
            QuarkusComponentTestConfiguration configuration = (QuarkusComponentTestConfiguration)context.getRoot().getStore(NAMESPACE).get((Object)KEY_TEST_CLASS_CONFIG, QuarkusComponentTestConfiguration.class);
            Optional testMethod = context.getTestMethod();
            if (testMethod.isPresent()) {
                configuration = configuration.update((Method)testMethod.get());
            }
            ConfigProviderResolver oldConfigProviderResolver = ConfigProviderResolver.instance();
            context.getRoot().getStore(NAMESPACE).put((Object)KEY_OLD_CONFIG_PROVIDER_RESOLVER, (Object)oldConfigProviderResolver);
            SmallRyeConfigProviderResolver smallRyeConfigProviderResolver = new SmallRyeConfigProviderResolver();
            ConfigProviderResolver.setInstance((ConfigProviderResolver)smallRyeConfigProviderResolver);
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            SmallRyeConfigBuilder configBuilder = new SmallRyeConfigBuilder().forClassLoader(tccl).addDefaultInterceptors().addDefaultSources().withSources((ConfigSourceProvider)new ApplicationPropertiesConfigSourceLoader.InFileSystem()).withSources((ConfigSourceProvider)new ApplicationPropertiesConfigSourceLoader.InClassPath()).withSources(new ConfigSource[]{new QuarkusComponentTestConfigSource(configuration.configProperties, configuration.configSourceOrdinal)});
            Set configMappings = (Set)context.getRoot().getStore(NAMESPACE).get((Object)KEY_CONFIG_MAPPINGS, Set.class);
            if (configMappings != null) {
                for (ConfigMappings.ConfigClassWithPrefix mapping : configMappings) {
                    configBuilder.withMapping(mapping.getKlass(), mapping.getPrefix());
                }
            }
            SmallRyeConfig config = configBuilder.build();
            smallRyeConfigProviderResolver.registerConfig((Config)config, tccl);
            context.getRoot().getStore(NAMESPACE).put((Object)KEY_CONFIG, (Object)config);
            ConfigBeanCreator.setClassLoader(tccl);
            Object testInstance = context.getRequiredTestInstance();
            context.getRoot().getStore(NAMESPACE).put((Object)KEY_INJECTED_FIELDS, this.injectFields(context.getRequiredTestClass(), testInstance));
        }
    }

    private BeanRegistrar registrarForMock(final MockBeanConfiguratorImpl<?> mock) {
        return new BeanRegistrar(){

            public void register(BeanRegistrar.RegistrationContext context) {
                BeanConfigurator configurator = context.configure(mock.beanClass);
                configurator.scope(mock.scope);
                mock.jandexTypes().forEach(arg_0 -> ((BeanConfigurator)configurator).addType(arg_0));
                mock.jandexQualifiers().forEach(arg_0 -> ((BeanConfigurator)configurator).addQualifier(arg_0));
                if (mock.name != null) {
                    configurator.name(mock.name);
                }
                configurator.alternative(mock.alternative);
                if (mock.priority != null) {
                    configurator.priority(mock.priority.intValue());
                }
                if (mock.defaultBean) {
                    configurator.defaultBean();
                }
                String key = UUID.randomUUID().toString();
                MockBeanCreator.registerCreate(key, (Function)QuarkusComponentTestExtension.cast(mock.create));
                ((BeanConfigurator)((BeanConfigurator)configurator.creator(MockBeanCreator.class)).param("createKey", key)).done();
            }
        };
    }

    private static Annotation[] getQualifiers(Field field, BeanManager beanManager) {
        Annotation[] annotations;
        ArrayList<Annotation> ret = new ArrayList<Annotation>();
        for (Annotation fieldAnnotation : annotations = field.getDeclaredAnnotations()) {
            if (!beanManager.isQualifier(fieldAnnotation.annotationType())) continue;
            ret.add(fieldAnnotation);
        }
        return ret.toArray(new Annotation[0]);
    }

    private static Set<AnnotationInstance> getQualifiers(Field field, Collection<DotName> qualifiers) {
        Annotation[] fieldAnnotations;
        HashSet<AnnotationInstance> ret = new HashSet<AnnotationInstance>();
        for (Annotation annotation : fieldAnnotations = field.getDeclaredAnnotations()) {
            if (!qualifiers.contains(DotName.createSimple(annotation.annotationType()))) continue;
            ret.add(Annotations.jandexAnnotation((Annotation)annotation));
        }
        return ret;
    }

    private ClassLoader initArcContainer(final ExtensionContext extensionContext, final QuarkusComponentTestConfiguration configuration) {
        IndexView index;
        final Class testClass = extensionContext.getRequiredTestClass();
        List<Field> testClassInjectionPoints = this.findInjectFields(testClass);
        if (configuration.componentClasses.isEmpty()) {
            throw new IllegalStateException("No component classes to test");
        }
        try {
            Arc.shutdown();
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occured during ArC shutdown: " + e);
        }
        try {
            Indexer indexer = new Indexer();
            for (Class<?> componentClass : configuration.componentClasses) {
                this.indexComponentClass(indexer, componentClass);
            }
            indexer.indexClass(ConfigProperty.class);
            index = BeanArchives.buildImmutableBeanArchiveIndex((IndexView[])new IndexView[]{indexer.complete()});
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create index", e);
        }
        ClassLoader testClassClassLoader = testClass.getClassLoader();
        boolean isContinuousTesting = testClassClassLoader instanceof QuarkusClassLoader;
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        final IndexView computingIndex = BeanArchives.buildComputingBeanArchiveIndex((ClassLoader)oldTccl, new ConcurrentHashMap(), (IndexView)index);
        try {
            Set generatedResources;
            final ArrayList qualifiers = new ArrayList();
            final HashSet<String> interceptorBindings = new HashSet<String>();
            AtomicReference<BeanResolver> beanResolver = new AtomicReference<BeanResolver>();
            BeanProcessor.Builder builder = BeanProcessor.builder().setName(testClass.getName().replace('.', '_')).addRemovalExclusion(b -> {
                if (b.getTarget().isPresent() && ((AnnotationTarget)b.getTarget().get()).hasDeclaredAnnotation(Unremovable.class)) {
                    return true;
                }
                for (Field injectionPoint : testClassInjectionPoints) {
                    if (!((BeanResolver)beanResolver.get()).matches(b, Types.jandexType((Type)injectionPoint.getGenericType()), QuarkusComponentTestExtension.getQualifiers(injectionPoint, qualifiers))) continue;
                    return true;
                }
                return false;
            }).setImmutableBeanArchiveIndex(index).setComputingBeanArchiveIndex(computingIndex).setRemoveUnusedBeans(true);
            final File componentsProviderFile = this.getComponentsProviderFile(testClass);
            if (isContinuousTesting) {
                generatedResources = Set.of();
                final HashMap classes = new HashMap();
                builder.setOutput(new ResourceOutput(){

                    public void writeResource(ResourceOutput.Resource resource) throws IOException {
                        switch (resource.getType()) {
                            case JAVA_CLASS: {
                                classes.put(resource.getName() + ".class", resource.getData());
                                ((QuarkusClassLoader)testClass.getClassLoader()).reset(classes, Map.of());
                                break;
                            }
                            case SERVICE_PROVIDER: {
                                if (!resource.getName().endsWith(ComponentsProvider.class.getName())) break;
                                componentsProviderFile.getParentFile().mkdirs();
                                try (FileOutputStream out = new FileOutputStream(componentsProviderFile);){
                                    out.write(resource.getData());
                                    break;
                                }
                            }
                            default: {
                                throw new IllegalArgumentException("Unsupported resource type: " + resource.getType());
                            }
                        }
                    }
                });
            } else {
                generatedResources = new HashSet();
                Iterator<MockBeanConfiguratorImpl<?>> testOutputDirectory = this.getTestOutputDirectory(testClass);
                builder.setOutput(new ResourceOutput(){
                    final /* synthetic */ File val$testOutputDirectory;
                    final /* synthetic */ File val$componentsProviderFile;
                    {
                        this.val$testOutputDirectory = file;
                        this.val$componentsProviderFile = file2;
                    }

                    public void writeResource(ResourceOutput.Resource resource) throws IOException {
                        switch (resource.getType()) {
                            case JAVA_CLASS: {
                                generatedResources.add(resource.writeTo(this.val$testOutputDirectory).toPath());
                                break;
                            }
                            case SERVICE_PROVIDER: {
                                if (!resource.getName().endsWith(ComponentsProvider.class.getName())) break;
                                this.val$componentsProviderFile.getParentFile().mkdirs();
                                try (FileOutputStream out = new FileOutputStream(this.val$componentsProviderFile);){
                                    out.write(resource.getData());
                                    break;
                                }
                            }
                            default: {
                                throw new IllegalArgumentException("Unsupported resource type: " + resource.getType());
                            }
                        }
                    }
                });
            }
            extensionContext.getRoot().getStore(NAMESPACE).put((Object)KEY_GENERATED_RESOURCES, generatedResources);
            builder.addAnnotationTransformer(((AnnotationsTransformer.FieldTransformerBuilder)((AnnotationsTransformer.FieldTransformerBuilder)AnnotationsTransformer.appliedToField().whenContainsAny(qualifiers)).whenContainsNone(new DotName[]{DotName.createSimple(Inject.class)})).thenTransform(t -> t.add(Inject.class, new AnnotationValue[0])));
            builder.addAnnotationTransformer((AnnotationsTransformer)new JaxrsSingletonTransformer());
            for (AnnotationsTransformer transformer : configuration.annotationsTransformers) {
                builder.addAnnotationTransformer(transformer);
            }
            builder.addBeanRegistrar(new BeanRegistrar(){

                public void register(BeanRegistrar.RegistrationContext registrationContext) {
                    long start = System.nanoTime();
                    List beans = registrationContext.beans().collect();
                    BeanDeployment beanDeployment = (BeanDeployment)registrationContext.get(BuildExtension.Key.DEPLOYMENT);
                    HashSet<InjectionPointInfo.TypeAndQualifiers> unsatisfiedInjectionPoints = new HashSet<InjectionPointInfo.TypeAndQualifiers>();
                    boolean configInjectionPoint = false;
                    HashSet<InjectionPointInfo.TypeAndQualifiers> configPropertyInjectionPoints = new HashSet<InjectionPointInfo.TypeAndQualifiers>();
                    HashMap<String, Set> prefixToConfigMappings = new HashMap<String, Set>();
                    DotName configDotName = DotName.createSimple(Config.class);
                    DotName configPropertyDotName = DotName.createSimple(ConfigProperty.class);
                    DotName configMappingDotName = DotName.createSimple(ConfigMapping.class);
                    for (InjectionPointInfo injectionPoint : registrationContext.getInjectionPoints()) {
                        AnnotationInstance configMapping;
                        ClassInfo clazz;
                        if (injectionPoint.getRequiredType().name().equals((Object)configDotName) && injectionPoint.hasDefaultedQualifier()) {
                            configInjectionPoint = true;
                            continue;
                        }
                        if (injectionPoint.getRequiredQualifier(configPropertyDotName) != null) {
                            configPropertyInjectionPoints.add(new InjectionPointInfo.TypeAndQualifiers(injectionPoint.getRequiredType(), injectionPoint.getRequiredQualifiers()));
                            continue;
                        }
                        BuiltinBean builtin = BuiltinBean.resolve((InjectionPointInfo)injectionPoint);
                        if (builtin != null && builtin != BuiltinBean.INSTANCE && builtin != BuiltinBean.LIST) continue;
                        org.jboss.jandex.Type requiredType = injectionPoint.getRequiredType();
                        HashSet<AnnotationInstance> requiredQualifiers = injectionPoint.getRequiredQualifiers();
                        if (builtin == BuiltinBean.LIST) {
                            requiredType = (org.jboss.jandex.Type)requiredType.asParameterizedType().arguments().get(0);
                            requiredQualifiers = new HashSet<AnnotationInstance>(requiredQualifiers);
                            requiredQualifiers.removeIf(q -> q.name().equals((Object)DotNames.ALL));
                            if (requiredQualifiers.isEmpty()) {
                                requiredQualifiers.add(AnnotationInstance.builder((DotName)DotNames.DEFAULT).build());
                            }
                        }
                        if (requiredType.kind() == Type.Kind.CLASS && (clazz = computingIndex.getClassByName(requiredType.name())) != null && clazz.isInterface() && (configMapping = clazz.declaredAnnotation(configMappingDotName)) != null) {
                            AnnotationValue prefixValue = configMapping.value("prefix");
                            String prefix = prefixValue == null ? "" : prefixValue.asString();
                            Set mappingClasses = prefixToConfigMappings.computeIfAbsent(prefix, k -> new HashSet());
                            mappingClasses.add(clazz.name().toString());
                        }
                        if (QuarkusComponentTestExtension.this.isSatisfied(requiredType, requiredQualifiers, injectionPoint, beans, beanDeployment, configuration)) continue;
                        if (requiredType.kind() == Type.Kind.PRIMITIVE || requiredType.kind() == Type.Kind.ARRAY) {
                            throw new IllegalStateException("Found an unmockable unsatisfied injection point: " + injectionPoint.getTargetInfo());
                        }
                        unsatisfiedInjectionPoints.add(new InjectionPointInfo.TypeAndQualifiers(requiredType, requiredQualifiers));
                        LOG.debugf("Unsatisfied injection point found: %s", (Object)injectionPoint.getTargetInfo());
                    }
                    for (Field field : QuarkusComponentTestExtension.this.findFields(testClass, List.of(InjectMock.class))) {
                        Set<AnnotationInstance> requiredQualifiers = QuarkusComponentTestExtension.getQualifiers(field, qualifiers);
                        if (requiredQualifiers.isEmpty()) {
                            requiredQualifiers = Set.of(AnnotationInstance.builder((DotName)DotNames.DEFAULT).build());
                        }
                        unsatisfiedInjectionPoints.add(new InjectionPointInfo.TypeAndQualifiers(Types.jandexType((Type)field.getGenericType()), requiredQualifiers));
                    }
                    for (InjectionPointInfo.TypeAndQualifiers unsatisfied : unsatisfiedInjectionPoints) {
                        ClassInfo implementationClass = computingIndex.getClassByName(unsatisfied.type.name());
                        BeanConfigurator configurator = (BeanConfigurator)((BeanConfigurator)registrationContext.configure(implementationClass.name()).scope(Singleton.class)).addType(unsatisfied.type);
                        unsatisfied.qualifiers.forEach(arg_0 -> ((BeanConfigurator)configurator).addQualifier(arg_0));
                        ((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)configurator.param("implementationClass", implementationClass)).creator(MockBeanCreator.class)).defaultBean()).identifier("dummy")).done();
                    }
                    if (configInjectionPoint) {
                        ((BeanConfigurator)((BeanConfigurator)registrationContext.configure(Config.class).addType(Config.class)).creator(ConfigBeanCreator.class)).done();
                    }
                    if (!configPropertyInjectionPoints.isEmpty()) {
                        BeanConfigurator configPropertyConfigurator = (BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)registrationContext.configure(Object.class).identifier("configProperty")).addQualifier(ConfigProperty.class)).param("useDefaultConfigProperties", configuration.useDefaultConfigProperties)).addInjectionPoint((org.jboss.jandex.Type)ClassType.create(InjectionPoint.class), new AnnotationInstance[0])).creator(ConfigPropertyBeanCreator.class);
                        for (InjectionPointInfo.TypeAndQualifiers configPropertyInjectionPoint : configPropertyInjectionPoints) {
                            configPropertyConfigurator.addType(configPropertyInjectionPoint.type);
                        }
                        configPropertyConfigurator.done();
                    }
                    if (!prefixToConfigMappings.isEmpty()) {
                        HashSet<ConfigMappings.ConfigClassWithPrefix> configMappings = new HashSet<ConfigMappings.ConfigClassWithPrefix>();
                        for (Map.Entry e : prefixToConfigMappings.entrySet()) {
                            for (String mapping : (Set)e.getValue()) {
                                DotName mappingName = DotName.createSimple((String)mapping);
                                ((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)registrationContext.configure(mappingName).addType(mappingName)).creator(ConfigMappingBeanCreator.class)).param("mappingClass", mapping)).param("prefix", (String)e.getKey())).done();
                                configMappings.add(ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix(ConfigMappingBeanCreator.tryLoad(mapping), (String)((String)e.getKey())));
                            }
                        }
                        extensionContext.getRoot().getStore(NAMESPACE).put((Object)QuarkusComponentTestExtension.KEY_CONFIG_MAPPINGS, configMappings);
                    }
                    LOG.debugf("Test injection points analyzed in %s ms [found: %s, mocked: %s]", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start), (long)registrationContext.getInjectionPoints().size(), (long)unsatisfiedInjectionPoints.size());
                    QuarkusComponentTestExtension.this.processTestInterceptorMethods(testClass, extensionContext, registrationContext, interceptorBindings);
                }
            });
            for (MockBeanConfiguratorImpl<?> mockConfigurator : configuration.mockConfigurators) {
                builder.addBeanRegistrar(this.registrarForMock(mockConfigurator));
            }
            BeanProcessor beanProcessor = builder.build();
            try {
                Consumer<BytecodeTransformer> unsupportedBytecodeTransformer = new Consumer<BytecodeTransformer>(){

                    @Override
                    public void accept(BytecodeTransformer transformer) {
                        throw new UnsupportedOperationException();
                    }
                };
                ContextRegistrar.RegistrationContext registrationContext = beanProcessor.registerCustomContexts();
                qualifiers.addAll(((Map)registrationContext.get(BuildExtension.Key.QUALIFIERS)).keySet());
                for (DotName binding : ((Map)registrationContext.get(BuildExtension.Key.INTERCEPTOR_BINDINGS)).keySet()) {
                    interceptorBindings.add(binding.toString());
                }
                beanResolver.set(((BeanDeployment)registrationContext.get(BuildExtension.Key.DEPLOYMENT)).getBeanResolver());
                beanProcessor.registerScopes();
                beanProcessor.registerBeans();
                beanProcessor.getBeanDeployment().initBeanByTypeMap();
                beanProcessor.registerSyntheticObservers();
                beanProcessor.initialize((Consumer)unsupportedBytecodeTransformer, Collections.emptyList());
                BeanDeploymentValidator.ValidationContext validationContext = beanProcessor.validate((Consumer)unsupportedBytecodeTransformer);
                beanProcessor.processValidationErrors(validationContext);
                ExecutorService executor = Executors.newCachedThreadPool();
                beanProcessor.generateResources(null, new HashSet(), (Consumer)unsupportedBytecodeTransformer, true, executor);
                executor.shutdown();
            }
            catch (IOException e) {
                throw new IllegalStateException("Error generating resources", e);
            }
            QuarkusComponentTestClassLoader testClassLoader = new QuarkusComponentTestClassLoader(isContinuousTesting ? testClassClassLoader : oldTccl, componentsProviderFile, null);
            Thread.currentThread().setContextClassLoader(testClassLoader);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return oldTccl;
    }

    private void processTestInterceptorMethods(Class<?> testClass, ExtensionContext extensionContext, BeanRegistrar.RegistrationContext registrationContext, Set<String> interceptorBindings) {
        for (Method method : this.findMethods(testClass, List.of(AroundInvoke.class, PostConstruct.class, PreDestroy.class, AroundConstruct.class))) {
            InterceptionType interceptionType;
            Set<Annotation> bindings = this.findBindings(method, interceptorBindings);
            if (bindings.isEmpty()) {
                throw new IllegalStateException("No bindings declared on a test interceptor method: " + method);
            }
            this.validateTestInterceptorMethod(method);
            String key = UUID.randomUUID().toString();
            InterceptorMethodCreator.registerCreate(key, ctx -> ic -> {
                Object instance = null;
                if (!Modifier.isStatic(method.getModifiers())) {
                    Object testInstance = extensionContext.getRoot().getStore(NAMESPACE).get((Object)KEY_TEST_INSTANCE);
                    if (testInstance == null) {
                        throw new IllegalStateException("Test instance not available");
                    }
                    instance = testInstance;
                    if (!method.canAccess(instance)) {
                        method.setAccessible(true);
                    }
                }
                return method.invoke(instance, ic);
            });
            if (method.isAnnotationPresent(AroundInvoke.class)) {
                interceptionType = InterceptionType.AROUND_INVOKE;
            } else if (method.isAnnotationPresent(PostConstruct.class)) {
                interceptionType = InterceptionType.POST_CONSTRUCT;
            } else if (method.isAnnotationPresent(PreDestroy.class)) {
                interceptionType = InterceptionType.PRE_DESTROY;
            } else if (method.isAnnotationPresent(AroundConstruct.class)) {
                interceptionType = InterceptionType.AROUND_CONSTRUCT;
            } else {
                throw new IllegalStateException("No interceptor annotation declared on: " + method);
            }
            int priority = 1;
            Priority priorityAnnotation = method.getAnnotation(Priority.class);
            if (priorityAnnotation != null) {
                priority = priorityAnnotation.value();
            }
            ((InterceptorConfigurator)registrationContext.configureInterceptor(interceptionType).identifier(key).priority(priority).bindings((AnnotationInstance[])bindings.stream().map(Annotations::jandexAnnotation).toArray(AnnotationInstance[]::new)).param("createKey", key)).creator(InterceptorMethodCreator.class);
        }
    }

    private void validateTestInterceptorMethod(Method method) {
        Object[] params = method.getParameters();
        if (params.length != 1 || !InvocationContext.class.isAssignableFrom(params[0].getType())) {
            throw new IllegalStateException("A test interceptor method must declare exactly one InvocationContext parameter:" + Arrays.toString(params));
        }
    }

    private Set<Annotation> findBindings(Method method, Set<String> bindings) {
        return Arrays.stream(method.getAnnotations()).filter(a -> bindings.contains(a.annotationType().getName())).collect(Collectors.toSet());
    }

    private void indexComponentClass(Indexer indexer, Class<?> componentClass) {
        try {
            while (componentClass != null) {
                indexer.indexClass(componentClass);
                for (Annotation annotation : componentClass.getAnnotations()) {
                    indexer.indexClass(annotation.annotationType());
                }
                for (Field field : componentClass.getDeclaredFields()) {
                    this.indexAnnotatedElement(indexer, field);
                }
                for (Method method : componentClass.getDeclaredMethods()) {
                    this.indexAnnotatedElement(indexer, method);
                    for (Parameter param : method.getParameters()) {
                        this.indexAnnotatedElement(indexer, param);
                    }
                }
                for (Class<?> iface : componentClass.getInterfaces()) {
                    this.indexComponentClass(indexer, iface);
                }
                componentClass = componentClass.getSuperclass();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to index:" + componentClass, e);
        }
    }

    private void indexAnnotatedElement(Indexer indexer, AnnotatedElement element) throws IOException {
        for (Annotation annotation : element.getAnnotations()) {
            indexer.indexClass(annotation.annotationType());
        }
    }

    private boolean isSatisfied(org.jboss.jandex.Type requiredType, Set<AnnotationInstance> qualifiers, InjectionPointInfo injectionPoint, Iterable<BeanInfo> beans, BeanDeployment beanDeployment, QuarkusComponentTestConfiguration configuration) {
        for (BeanInfo beanInfo : beans) {
            if (!Beans.matches((BeanInfo)beanInfo, (org.jboss.jandex.Type)requiredType, qualifiers)) continue;
            LOG.debugf("Injection point %s satisfied by %s", (Object)injectionPoint.getTargetInfo(), (Object)beanInfo.toString());
            return true;
        }
        for (MockBeanConfiguratorImpl mockBeanConfiguratorImpl : configuration.mockConfigurators) {
            if (!mockBeanConfiguratorImpl.matches(beanDeployment.getBeanResolver(), requiredType, qualifiers)) continue;
            LOG.debugf("Injection point %s satisfied by %s", (Object)injectionPoint.getTargetInfo(), (Object)mockBeanConfiguratorImpl);
            return true;
        }
        return false;
    }

    private String nameToPath(String name) {
        return name.replace('.', File.separatorChar);
    }

    static <T> T cast(Object obj) {
        return (T)obj;
    }

    private List<FieldInjector> injectFields(Class<?> testClass, Object testInstance) throws Exception {
        ArrayList<FieldInjector> injectedFields = new ArrayList<FieldInjector>();
        for (Field field : this.findInjectFields(testClass)) {
            injectedFields.add(new FieldInjector(field, testInstance));
        }
        return injectedFields;
    }

    private List<Field> findInjectFields(Class<?> testClass) {
        Class<? extends Annotation> deprecatedInjectMock = this.loadDeprecatedInjectMock();
        List<Class<? extends Annotation>> injectAnnotations = deprecatedInjectMock != null ? List.of(Inject.class, InjectMock.class, deprecatedInjectMock) : List.of(Inject.class, InjectMock.class);
        return this.findFields(testClass, injectAnnotations);
    }

    private List<Field> findFields(Class<?> testClass, List<Class<? extends Annotation>> annotations) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> current = testClass;
        while (current.getSuperclass() != null) {
            block1: for (Field field : current.getDeclaredFields()) {
                for (Class<? extends Annotation> annotation : annotations) {
                    if (!field.isAnnotationPresent(annotation)) continue;
                    fields.add(field);
                    continue block1;
                }
            }
            current = current.getSuperclass();
        }
        return fields;
    }

    private List<Method> findMethods(Class<?> testClass, List<Class<? extends Annotation>> annotations) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Class<?> current = testClass;
        while (current.getSuperclass() != null) {
            block1: for (Method method : current.getDeclaredMethods()) {
                for (Class<? extends Annotation> annotation : annotations) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    methods.add(method);
                    continue block1;
                }
            }
            current = current.getSuperclass();
        }
        return methods;
    }

    private Class<? extends Annotation> loadDeprecatedInjectMock() {
        try {
            return Class.forName("io.quarkus.test.junit.mockito.InjectMock");
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static boolean isListRequiredType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return List.class.equals((Object)parameterizedType.getRawType());
        }
        return false;
    }

    private static boolean isTypeArgumentInstanceHandle(Type type) {
        Type typeArgument = ((ParameterizedType)type).getActualTypeArguments()[0];
        if (typeArgument instanceof ParameterizedType) {
            return ((ParameterizedType)typeArgument).getRawType().equals(InstanceHandle.class);
        }
        return false;
    }

    private File getTestOutputDirectory(Class<?> testClass) {
        File testOutputDirectory;
        String outputDirectory = System.getProperty(QUARKUS_TEST_COMPONENT_OUTPUT_DIRECTORY);
        if (outputDirectory != null) {
            testOutputDirectory = new File(outputDirectory);
        } else {
            String testClassResourceName = testClass.getName().replace('.', '/') + ".class";
            String testPath = testClass.getClassLoader().getResource(testClassResourceName).getFile();
            String testClassesRootPath = testPath.substring(0, testPath.length() - testClassResourceName.length());
            testOutputDirectory = new File(testClassesRootPath);
        }
        if (!testOutputDirectory.canWrite()) {
            throw new IllegalStateException("Invalid test output directory: " + testOutputDirectory);
        }
        return testOutputDirectory;
    }

    private File getComponentsProviderFile(Class<?> testClass) {
        File buildDir;
        File targetDir = new File("target");
        File generatedSourcesDirectory = targetDir.canWrite() ? new File(targetDir, "generated-arc-sources") : ((buildDir = new File("build")).canWrite() ? new File(buildDir, "generated-arc-sources") : new File("quarkus-component-test/generated-arc-sources"));
        return new File(new File(generatedSourcesDirectory, this.nameToPath(testClass.getPackage().getName())), ComponentsProvider.class.getSimpleName());
    }

    static class FieldInjector {
        private final Field field;
        private final List<InstanceHandle<?>> unsetHandles;

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public FieldInjector(Field field, Object testInstance) throws Exception {
            super();
            this.field = field;
            container = Arc.container();
            beanManager = container.beanManager();
            requiredType = field.getGenericType();
            qualifiers = QuarkusComponentTestExtension.getQualifiers(field, beanManager);
            if (qualifiers.length <= 0) ** GOTO lbl18
            if (!Arrays.stream(qualifiers).anyMatch((Predicate<Annotation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/annotation/Annotation;)Z)((All.Literal)All.Literal.INSTANCE))) ** GOTO lbl18
            if (QuarkusComponentTestExtension.isListRequiredType(requiredType)) {
                handles = container.listAll(requiredType, qualifiers);
                injectedInstance /* !! */  = QuarkusComponentTestExtension.isTypeArgumentInstanceHandle(requiredType) != false ? handles : handles.stream().map((Function<InstanceHandle, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(), (Lio/quarkus/arc/InstanceHandle;)Ljava/lang/Object;)()).collect(Collectors.toUnmodifiableList());
                this.unsetHandles = (List)QuarkusComponentTestExtension.cast(handles);
            } else {
                throw new IllegalStateException("Invalid injection point type: " + field);
lbl18:
                // 2 sources

                handle = container.instance(requiredType, qualifiers);
                if (field.isAnnotationPresent(Inject.class)) {
                    if (handle.getBean().getKind() == InjectableBean.Kind.SYNTHETIC) {
                        throw new IllegalStateException(String.format("The injected field %s expects a real component; but obtained: %s", new Object[]{field, handle.getBean()}));
                    }
                } else {
                    if (!handle.isAvailable()) {
                        throw new IllegalStateException(String.format("The injected field %s expects a mocked bean; but obtained null", new Object[]{field}));
                    }
                    if (handle.getBean().getKind() != InjectableBean.Kind.SYNTHETIC) {
                        throw new IllegalStateException(String.format("The injected field %s expects a mocked bean; but obtained: %s", new Object[]{field, handle.getBean()}));
                    }
                }
                injectedInstance /* !! */  = handle.get();
                this.unsetHandles = List.of(handle);
            }
            if (!field.canAccess(testInstance)) {
                field.setAccessible(true);
            }
            field.set(testInstance, injectedInstance /* !! */ );
        }

        void unset(Object testInstance) throws Exception {
            for (InstanceHandle<?> handle : this.unsetHandles) {
                if (handle.getBean() == null || !handle.getBean().getScope().equals(Dependent.class)) continue;
                try {
                    handle.destroy();
                }
                catch (Exception e) {
                    LOG.errorf((Throwable)e, "Unable to destroy the injected %s", (Object)handle.getBean());
                }
            }
            this.field.set(testInstance, null);
        }
    }
}

