/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime;

import io.quarkus.kafka.client.runtime.ui.model.request.KafkaCreateTopicRequest;
import io.smallrye.common.annotation.Identifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.resource.ResourcePatternFilter;

@ApplicationScoped
public class KafkaAdminClient {
    private static final int DEFAULT_ADMIN_CLIENT_TIMEOUT = 5000;
    @Inject
    @Identifier(value="default-kafka-broker")
    Map<String, Object> config;
    private AdminClient client;

    @PostConstruct
    void init() {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("request.timeout.ms", 5000);
        for (Map.Entry<String, Object> entry : this.config.entrySet()) {
            if (!AdminClientConfig.configNames().contains(entry.getKey())) continue;
            conf.put(entry.getKey(), entry.getValue().toString());
        }
        this.client = AdminClient.create(conf);
    }

    @PreDestroy
    void stop() {
        this.client.close();
    }

    public DescribeClusterResult getCluster() {
        return this.client.describeCluster();
    }

    public Collection<TopicListing> getTopics() throws InterruptedException, ExecutionException {
        return (Collection)this.client.listTopics().listings().get();
    }

    public Collection<ConsumerGroupDescription> getConsumerGroups() throws InterruptedException, ExecutionException {
        List consumerGroupIds = ((Collection)this.client.listConsumerGroups().all().get()).stream().map(ConsumerGroupListing::groupId).collect(Collectors.toList());
        return ((Map)this.client.describeConsumerGroups(consumerGroupIds).all().get()).values();
    }

    public boolean deleteTopic(String name) {
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(name);
        DeleteTopicsResult dtr = this.client.deleteTopics(topics);
        return dtr.topicNameValues() != null;
    }

    public boolean createTopic(KafkaCreateTopicRequest kafkaCreateTopicRq) {
        Integer partitions = Optional.ofNullable(kafkaCreateTopicRq.getPartitions()).orElse(1);
        Short replications = Optional.ofNullable(kafkaCreateTopicRq.getReplications()).orElse((short)1);
        NewTopic newTopic = new NewTopic(kafkaCreateTopicRq.getTopicName(), partitions.intValue(), replications.shortValue());
        CreateTopicsResult ctr = this.client.createTopics(List.of(newTopic));
        return ctr.values() != null;
    }

    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(String groupId) {
        return this.client.listConsumerGroupOffsets(groupId);
    }

    public Collection<AclBinding> getAclInfo() throws InterruptedException, ExecutionException {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, AccessControlEntryFilter.ANY);
        DescribeAclsOptions options = new DescribeAclsOptions().timeoutMs(Integer.valueOf(1000));
        return (Collection)this.client.describeAcls(filter, options).values().get();
    }

    public Map<String, TopicDescription> describeTopics(Collection<String> topicNames) throws InterruptedException, ExecutionException {
        return (Map)this.client.describeTopics(topicNames).allTopicNames().get();
    }
}

