/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.lang.JoseException;

public class JsonWebKeySet {
    private static final String RSA_KEY_TYPE = "RSA";
    private static final String EC_KEY_TYPE = "EC";
    private static final String SIGNATURE_USE = "sig";
    private Map<String, Key> keysWithKeyId = new HashMap<String, Key>();
    private Map<String, Key> keysWithThumbprints = new HashMap<String, Key>();
    private Key keyWithoutKeyIdAndThumbprint;

    public JsonWebKeySet(String json) {
        this.initKeys(json);
    }

    private void initKeys(String json) {
        try {
            org.jose4j.jwk.JsonWebKeySet jwkSet = new org.jose4j.jwk.JsonWebKeySet(json);
            for (JsonWebKey jwkKey : jwkSet.getJsonWebKeys()) {
                boolean calculateThumbprintIfMissing;
                String x5t;
                if (!JsonWebKeySet.isSupportedJwkKey(jwkKey)) continue;
                if (jwkKey.getKeyId() != null) {
                    this.keysWithKeyId.put(jwkKey.getKeyId(), jwkKey.getKey());
                }
                if ((x5t = ((PublicJsonWebKey)jwkKey).getX509CertificateSha1Thumbprint(calculateThumbprintIfMissing = true)) == null || jwkKey.getKey() == null) continue;
                this.keysWithThumbprints.put(x5t, jwkKey.getKey());
            }
            if (this.keysWithKeyId.isEmpty() && this.keysWithThumbprints.isEmpty() && jwkSet.getJsonWebKeys().size() == 1 && JsonWebKeySet.isSupportedJwkKey((JsonWebKey)jwkSet.getJsonWebKeys().get(0))) {
                this.keyWithoutKeyIdAndThumbprint = ((JsonWebKey)jwkSet.getJsonWebKeys().get(0)).getKey();
            }
        }
        catch (JoseException ex) {
            throw new OIDCException(ex);
        }
    }

    private static boolean isSupportedJwkKey(JsonWebKey jwkKey) {
        return !(!RSA_KEY_TYPE.equals(jwkKey.getKeyType()) && !EC_KEY_TYPE.equals(jwkKey.getKeyType()) && jwkKey.getKeyType() != null || !SIGNATURE_USE.equals(jwkKey.getUse()) && jwkKey.getUse() != null);
    }

    public Key getKeyWithId(String kid) {
        return this.keysWithKeyId.get(kid);
    }

    public Key getKeyWithThumbprint(String x5t) {
        return this.keysWithThumbprints.get(x5t);
    }

    public Key getKeyWithoutKeyIdAndThumbprint() {
        return this.keyWithoutKeyIdAndThumbprint;
    }
}

