/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment;

import io.quarkus.deployment.util.AsmUtil;
import java.util.StringJoiner;
import org.jboss.jandex.DotName;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.objectweb.asm.Type;

public class ByteCodeType {
    private final Type type;

    public ByteCodeType(Type type) {
        this.type = type;
    }

    public ByteCodeType(Class<?> type) {
        this.type = Type.getType(type);
    }

    public ByteCodeType(org.jboss.jandex.Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            this.type = this.toAsm(type.asPrimitiveType());
        } else {
            String typeDescriptor = type.kind() == Type.Kind.PRIMITIVE ? type.toString() : "L" + type.name().toString().replace('.', '/') + ";";
            this.type = Type.getType((String)typeDescriptor);
        }
    }

    public String descriptor() {
        return this.type.getDescriptor();
    }

    public DotName dotName() {
        return DotName.createSimple((String)this.type.getClassName());
    }

    public String internalName() {
        return this.type.getInternalName();
    }

    public boolean isPrimitive() {
        return this.type().getSort() <= 8;
    }

    private Type toAsm(PrimitiveType primitive) {
        switch (primitive.name().toString()) {
            case "byte": {
                return Type.BYTE_TYPE;
            }
            case "char": {
                return Type.CHAR_TYPE;
            }
            case "double": {
                return Type.DOUBLE_TYPE;
            }
            case "float": {
                return Type.FLOAT_TYPE;
            }
            case "int": {
                return Type.INT_TYPE;
            }
            case "long": {
                return Type.LONG_TYPE;
            }
            case "short": {
                return Type.SHORT_TYPE;
            }
            case "boolean": {
                return Type.BOOLEAN_TYPE;
            }
        }
        return null;
    }

    public String toString() {
        return new StringJoiner(", ", ByteCodeType.class.getSimpleName() + "[", "]").add(this.type.toString()).toString();
    }

    public Type type() {
        return this.type;
    }

    public ByteCodeType unbox() {
        return new ByteCodeType(AsmUtil.WRAPPER_TO_PRIMITIVE.getOrDefault(this.type, this.type));
    }
}

