/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.common.deployment;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.processor.DefaultProducesHandler;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;

public class JsonDefaultProducersHandler
implements DefaultProducesHandler {
    private static final List<MediaType> PRODUCES_APPLICATION_JSON = Collections.singletonList(MediaType.APPLICATION_JSON_TYPE);
    private static final Set<DotName> SUPPORTED_JAVA_TYPES = Set.of(ResteasyReactiveDotNames.COLLECTION, ResteasyReactiveDotNames.LIST, ResteasyReactiveDotNames.SET, ResteasyReactiveDotNames.MAP);

    public List<MediaType> handle(DefaultProducesHandler.Context context) {
        if (context.config().isDefaultProduces() && this.isJsonCompatibleType(context)) {
            return PRODUCES_APPLICATION_JSON;
        }
        return Collections.emptyList();
    }

    private boolean isJsonCompatibleType(DefaultProducesHandler.Context context) {
        if (context.httpMethod() == null) {
            return false;
        }
        Type type = context.nonAsyncReturnType();
        if (type.kind() != Type.Kind.CLASS && type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            return false;
        }
        DotName dotName = type.name();
        if (dotName.toString().startsWith("java")) {
            return SUPPORTED_JAVA_TYPES.contains(dotName);
        }
        if (dotName.toString().startsWith("jakarta")) {
            return false;
        }
        return context.index().getClassByName(dotName) != null;
    }
}

