/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.deployment;

import io.quarkus.scheduler.deployment.SchedulerDotNames;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

final class KotlinUtil {
    private static final Type VOID_CLASS = Type.create((DotName)SchedulerDotNames.VOID, (Type.Kind)Type.Kind.CLASS);

    private KotlinUtil() {
    }

    static boolean isSuspendMethod(MethodInfo methodInfo) {
        if (!methodInfo.parameters().isEmpty()) {
            return ((Type)methodInfo.parameters().get(methodInfo.parameters().size() - 1)).name().equals((Object)SchedulerDotNames.CONTINUATION);
        }
        return false;
    }

    static Type determineReturnTypeOfSuspendMethod(MethodInfo methodInfo) {
        Type lastParamType = (Type)methodInfo.parameters().get(methodInfo.parameters().size() - 1);
        if (lastParamType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            throw new IllegalStateException("Something went wrong during parameter type resolution - expected " + lastParamType + " to be a Continuation with a generic type");
        }
        if ((lastParamType = (Type)lastParamType.asParameterizedType().arguments().get(0)).kind() != Type.Kind.WILDCARD_TYPE) {
            throw new IllegalStateException("Something went wrong during parameter type resolution - expected " + lastParamType + " to be a Continuation with a generic type");
        }
        if ((lastParamType = lastParamType.asWildcardType().superBound()).name().equals((Object)SchedulerDotNames.KOTLIN_UNIT)) {
            return VOID_CLASS;
        }
        return lastParamType;
    }
}

