/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.CurrentContextFactoryBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AnnotationProxyBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.ConsumeEvent;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.deployment.EventBusConsumer;
import io.quarkus.vertx.deployment.EventConsumerBusinessMethodItem;
import io.quarkus.vertx.deployment.LocalCodecSelectorTypesBuildItem;
import io.quarkus.vertx.deployment.MessageCodecBuildItem;
import io.quarkus.vertx.deployment.VertxBuildConfig;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.quarkus.vertx.deployment.VertxConstants;
import io.quarkus.vertx.runtime.VertxEventBusConsumerRecorder;
import io.quarkus.vertx.runtime.VertxProducer;
import io.smallrye.common.annotation.RunOnVirtualThread;
import io.smallrye.mutiny.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class VertxProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)VertxProcessor.class.getName());

    VertxProcessor() {
    }

    @BuildStep
    void featureAndCapability(BuildProducer<FeatureBuildItem> feature, BuildProducer<CapabilityBuildItem> capability) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.VERTX));
    }

    @BuildStep
    AdditionalBeanBuildItem registerBean() {
        return AdditionalBeanBuildItem.unremovableOf(VertxProducer.class);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    VertxBuildItem build(CoreVertxBuildItem vertx, VertxEventBusConsumerRecorder recorder, List<EventConsumerBusinessMethodItem> messageConsumerBusinessMethods, BuildProducer<GeneratedClassBuildItem> generatedClass, AnnotationProxyBuildItem annotationProxy, LaunchModeBuildItem launchMode, ShutdownContextBuildItem shutdown, BuildProducer<ServiceStartBuildItem> serviceStart, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, List<MessageCodecBuildItem> codecs, LocalCodecSelectorTypesBuildItem localCodecSelectorTypes) {
        HashMap<Object, ConsumeEvent> messageConsumerConfigurations = new HashMap<Object, ConsumeEvent>();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        for (EventConsumerBusinessMethodItem businessMethod : messageConsumerBusinessMethods) {
            String invokerClass = EventBusConsumer.generateInvoker(businessMethod.getBean(), businessMethod.getMethod(), businessMethod.getConsumeEvent(), (ClassOutput)classOutput);
            messageConsumerConfigurations.put(invokerClass, (ConsumeEvent)annotationProxy.builder(businessMethod.getConsumeEvent(), ConsumeEvent.class).withDefaultValue("value", (Object)businessMethod.getBean().getBeanClass().toString()).build((ClassOutput)classOutput));
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{invokerClass}).build());
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        HashMap codecByClass = new HashMap();
        for (MessageCodecBuildItem messageCodecItem : codecs) {
            codecByClass.put(this.tryLoad(messageCodecItem.getType(), tccl), this.tryLoad(messageCodecItem.getCodec(), tccl));
        }
        ArrayList selectorTypes = new ArrayList();
        for (String name : localCodecSelectorTypes.getTypes()) {
            selectorTypes.add(this.tryLoad(name, tccl));
        }
        recorder.configureVertx(vertx.getVertx(), messageConsumerConfigurations, launchMode.getLaunchMode(), (ShutdownContext)shutdown, codecByClass, selectorTypes);
        serviceStart.produce((BuildItem)new ServiceStartBuildItem("vertx"));
        return new VertxBuildItem((RuntimeValue<Vertx>)recorder.forceStart(vertx.getVertx()));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void currentContextFactory(BuildProducer<CurrentContextFactoryBuildItem> currentContextFactory, VertxBuildConfig buildConfig, VertxEventBusConsumerRecorder recorder) {
        if (buildConfig.customizeArcContext()) {
            currentContextFactory.produce((BuildItem)new CurrentContextFactoryBuildItem(recorder.currentContextFactory()));
        }
    }

    @BuildStep
    public UnremovableBeanBuildItem unremovableBeans() {
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(VertxConstants.CONSUME_EVENT));
    }

    @BuildStep
    void collectEventConsumers(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<EventConsumerBusinessMethodItem> messageConsumerBusinessMethods, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> errors) {
        AnnotationStore annotationStore = (AnnotationStore)beanRegistrationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : beanRegistrationPhase.getContext().beans().classBeans()) {
            for (MethodInfo method : ((AnnotationTarget)bean.getTarget().get()).asClass().methods()) {
                AnnotationInstance consumeEvent;
                if (method.isSynthetic() || (consumeEvent = annotationStore.getAnnotation((AnnotationTarget)method, VertxConstants.CONSUME_EVENT)) == null) continue;
                List params = method.parameterTypes();
                if (params.size() == 2) {
                    if (!VertxConstants.isMessageHeaders(((Type)params.get(0)).name())) {
                        throw new IllegalStateException(String.format("An event consumer business method with two parameters must have MultiMap as the first parameter: %s [method: %s, bean:%s]", params, method, bean));
                    }
                    if (VertxConstants.isMessage(((Type)params.get(1)).name())) {
                        throw new IllegalStateException(String.format("An event consumer business method with two parameters must not accept io.vertx.core.eventbus.Message or io.vertx.mutiny.core.eventbus.Message: %s [method: %s, bean:%s]", params, method, bean));
                    }
                } else if (params.size() != 1) {
                    throw new IllegalStateException(String.format("An event consumer business method must accept exactly one parameter: %s [method: %s, bean:%s]", params, method, bean));
                }
                if (method.returnType().kind() != Type.Kind.VOID && VertxConstants.isMessage(((Type)params.get(0)).name())) {
                    throw new IllegalStateException(String.format("An event consumer business method that accepts io.vertx.core.eventbus.Message or io.vertx.mutiny.core.eventbus.Message must return void [method: %s, bean:%s]", method, bean));
                }
                if (method.hasAnnotation(RunOnVirtualThread.class) && consumeEvent.value("ordered") != null && consumeEvent.value("ordered").asBoolean()) {
                    throw new IllegalStateException(String.format("An event consumer business method that cannot use @RunOnVirtualThread and set the ordered attribute to true [method: %s, bean:%s]", method, bean));
                }
                messageConsumerBusinessMethods.produce((BuildItem)new EventConsumerBusinessMethodItem(bean, method, consumeEvent));
                LOGGER.debugf("Found event consumer business method %s declared on %s", (Object)method, (Object)bean);
            }
        }
    }

    @BuildStep
    AutoAddScopeBuildItem autoAddScope() {
        return AutoAddScopeBuildItem.builder().containsAnnotations(new DotName[]{VertxConstants.CONSUME_EVENT}).defaultScope(BuiltinScope.SINGLETON).reason("Found event consumer business methods").build();
    }

    @BuildStep
    void registerVerticleClasses(CombinedIndexBuildItem indexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        for (ClassInfo ci : indexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)AbstractVerticle.class.getName()))) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{ci.toString()}).build());
        }
    }

    @BuildStep
    void faultToleranceIntegration(Capabilities capabilities, BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        if (capabilities.isPresent("io.quarkus.smallrye.faulttolerance")) {
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.smallrye.faulttolerance.core.event.loop.EventLoop", new String[]{"io.smallrye.faulttolerance.vertx.VertxEventLoop"}));
        }
    }

    @BuildStep
    NativeImageConfigBuildItem reinitializeClassesForNetty() {
        NativeImageConfigBuildItem.Builder builder = NativeImageConfigBuildItem.builder();
        builder.addRuntimeReinitializedClass("io.vertx.core.http.impl.Http1xServerResponse").addRuntimeReinitializedClass("io.vertx.core.parsetools.impl.RecordParserImpl");
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.vertx.ext.web.client.impl.MultipartFormUpload")) {
            builder.addRuntimeReinitializedClass("io.vertx.ext.web.client.impl.MultipartFormUpload");
        }
        return builder.build();
    }

    private Class<?> tryLoad(String name, ClassLoader tccl) {
        try {
            return tccl.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load type: " + name, e);
        }
    }
}

