/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.jsonrpc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.quarkus.devui.deployment.jsonrpc.ByteArrayInputStreamDeserializer;
import io.quarkus.devui.deployment.jsonrpc.ByteArrayInputStreamSerializer;
import io.quarkus.devui.runtime.jsonrpc.json.JsonMapper;
import io.quarkus.devui.runtime.jsonrpc.json.JsonTypeAdapter;
import io.quarkus.vertx.runtime.jackson.ByteArrayDeserializer;
import io.quarkus.vertx.runtime.jackson.ByteArraySerializer;
import io.quarkus.vertx.runtime.jackson.InstantDeserializer;
import io.quarkus.vertx.runtime.jackson.InstantSerializer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DevUIDatabindCodec
implements JsonMapper {
    private final ObjectMapper mapper;
    private final ObjectMapper prettyMapper;
    private final Function<Map<String, Object>, ?> runtimeObjectDeserializer;
    private final Function<List<?>, ?> runtimeArrayDeserializer;

    private DevUIDatabindCodec(ObjectMapper mapper, Function<Map<String, Object>, ?> runtimeObjectDeserializer, Function<List<?>, ?> runtimeArrayDeserializer) {
        this.mapper = mapper;
        this.prettyMapper = mapper.copy();
        this.prettyMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.runtimeObjectDeserializer = runtimeObjectDeserializer;
        this.runtimeArrayDeserializer = runtimeArrayDeserializer;
    }

    public <T> T fromValue(Object json, Class<T> clazz) {
        Object value = this.mapper.convertValue(json, clazz);
        if (clazz == Object.class) {
            value = this.adapt(value);
        }
        return (T)value;
    }

    public <T> T fromString(String str, Class<T> clazz) throws DecodeException {
        return this.fromParser(this.createParser(str), clazz);
    }

    private JsonParser createParser(String str) {
        try {
            return this.mapper.getFactory().createParser(str);
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), (Throwable)e);
        }
    }

    private <T> T fromParser(JsonParser parser, Class<T> type) throws DecodeException {
        JsonToken remaining;
        Object value;
        try {
            value = this.mapper.readValue(parser, type);
            remaining = parser.nextToken();
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), (Throwable)e);
        }
        finally {
            DevUIDatabindCodec.close((Closeable)parser);
        }
        if (remaining != null) {
            throw new DecodeException("Unexpected trailing token");
        }
        if (type == Object.class) {
            value = this.adapt(value);
        }
        return (T)value;
    }

    public String toString(Object object, boolean pretty) throws EncodeException {
        try {
            ObjectMapper theMapper = pretty ? this.prettyMapper : this.mapper;
            return theMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void close(Closeable parser) {
        try {
            parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Object adapt(Object o) {
        try {
            if (o instanceof List) {
                List list = (List)o;
                return this.runtimeArrayDeserializer.apply(list);
            }
            if (o instanceof Map) {
                Map map = (Map)o;
                return this.runtimeObjectDeserializer.apply(map);
            }
            return o;
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode: " + e.getMessage());
        }
    }

    public static final class Factory
    implements JsonMapper.Factory {
        public JsonMapper create(JsonTypeAdapter<?, Map<String, Object>> jsonObjectAdapter, JsonTypeAdapter<?, List<?>> jsonArrayAdapter, JsonTypeAdapter<?, String> bufferAdapter) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            SimpleModule module = new SimpleModule("vertx-module-common");
            module.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer());
            module.addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserializer());
            module.addSerializer(byte[].class, (JsonSerializer)new ByteArraySerializer());
            module.addDeserializer(byte[].class, (JsonDeserializer)new ByteArrayDeserializer());
            module.addSerializer(ByteArrayInputStream.class, (JsonSerializer)new ByteArrayInputStreamSerializer());
            module.addDeserializer(ByteArrayInputStream.class, (JsonDeserializer)new ByteArrayInputStreamDeserializer());
            mapper.registerModule((Module)module);
            SimpleModule runtimeModule = new SimpleModule("vertx-module-runtime");
            Factory.addAdapterToObject(runtimeModule, jsonObjectAdapter);
            Factory.addAdapterToObject(runtimeModule, jsonArrayAdapter);
            Factory.addAdapterToString(runtimeModule, bufferAdapter);
            mapper.registerModule((Module)runtimeModule);
            return new DevUIDatabindCodec(mapper, jsonObjectAdapter.deserializer, jsonArrayAdapter.deserializer);
        }

        private static <T, S> void addAdapterToObject(SimpleModule module, final JsonTypeAdapter<T, S> adapter) {
            module.addSerializer(adapter.type, new JsonSerializer<T>(){

                public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                    jgen.writeObject(adapter.serializer.apply(value));
                }
            });
        }

        private static <T> void addAdapterToString(SimpleModule module, final JsonTypeAdapter<T, String> adapter) {
            module.addSerializer(adapter.type, new JsonSerializer<T>(){

                public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                    jgen.writeString((String)adapter.serializer.apply(value));
                }
            });
            module.addDeserializer(adapter.type, new JsonDeserializer<T>(){

                public T deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
                    return adapter.deserializer.apply(parser.getText());
                }
            });
        }
    }
}

