/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.multipart;

import java.io.IOException;
import java.nio.file.Path;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.multipart.FileUpload;
import org.jboss.resteasy.reactive.server.multipart.FormValue;

public class DefaultFileUpload
implements FileUpload {
    private final String name;
    private final FormValue fileUpload;

    public DefaultFileUpload(String name, FormValue fileUpload) {
        this.name = name;
        this.fileUpload = fileUpload;
    }

    public String name() {
        return this.name;
    }

    public Path filePath() {
        return this.fileUpload.getFileItem().getFile();
    }

    public String fileName() {
        return this.fileUpload.getFileName();
    }

    public long size() {
        try {
            return this.fileUpload.getFileItem().getFileSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String contentType() {
        return (String)this.fileUpload.getHeaders().getFirst((Object)"Content-Type");
    }

    public String charSet() {
        String ct = (String)this.fileUpload.getHeaders().getFirst((Object)"Content-Type");
        if (ct == null) {
            return null;
        }
        return HeaderUtil.extractQuotedValueFromHeader((String)ct, (String)"charset");
    }
}

