/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger.dql.common;

import io.shardingsphere.core.merger.MergedResult;
import io.shardingsphere.core.merger.dql.common.MemoryQueryResultRow;
import io.shardingsphere.core.util.SQLUtil;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.util.Calendar;
import java.util.Map;

public abstract class MemoryMergedResult
implements MergedResult {
    private final Map<String, Integer> labelAndIndexMap;
    private MemoryQueryResultRow currentResultSetRow;
    private boolean wasNull;

    @Override
    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (Blob.class == type || Clob.class == type || Reader.class == type || InputStream.class == type || SQLXML.class == type) {
            throw new SQLFeatureNotSupportedException();
        }
        Object result = this.currentResultSetRow.getCell(columnIndex);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public Object getValue(String columnLabel, Class<?> type) throws SQLException {
        if (Blob.class == type || Clob.class == type || Reader.class == type || InputStream.class == type || SQLXML.class == type) {
            throw new SQLFeatureNotSupportedException();
        }
        Object result = this.currentResultSetRow.getCell(this.labelAndIndexMap.containsKey(columnLabel) ? this.labelAndIndexMap.get(columnLabel) : this.labelAndIndexMap.get(SQLUtil.getExactlyValue(columnLabel)));
        this.wasNull = null == result;
        return result;
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        Object result = this.currentResultSetRow.getCell(columnIndex);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public Object getCalendarValue(String columnLabel, Class<?> type, Calendar calendar) {
        Object result = this.currentResultSetRow.getCell(this.labelAndIndexMap.get(columnLabel));
        this.wasNull = null == result;
        return result;
    }

    @Override
    public InputStream getInputStream(int columnIndex, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getInputStream(String columnLabel, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @ConstructorProperties(value={"labelAndIndexMap"})
    public MemoryMergedResult(Map<String, Integer> labelAndIndexMap) {
        this.labelAndIndexMap = labelAndIndexMap;
    }

    public void setCurrentResultSetRow(MemoryQueryResultRow currentResultSetRow) {
        this.currentResultSetRow = currentResultSetRow;
    }
}

