/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.metadata;

import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.metadata.ColumnMetaData;
import io.shardingsphere.core.metadata.TableMetaData;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.ShardingDataSourceNames;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ShardingMetaData {
    private Map<String, TableMetaData> tableMetaDataMap;

    public void init(ShardingRule shardingRule) throws SQLException {
        this.tableMetaDataMap = new HashMap<String, TableMetaData>(shardingRule.getTableRules().size(), 1.0f);
        for (TableRule each : shardingRule.getTableRules()) {
            this.refresh(each, shardingRule);
        }
    }

    public void refresh(TableRule each, ShardingRule shardingRule) throws SQLException {
        this.refresh(each, shardingRule, Collections.emptyMap());
    }

    public void refresh(TableRule each, ShardingRule shardingRule, Map<String, Connection> connectionMap) throws SQLException {
        this.tableMetaDataMap.put(each.getLogicTable(), this.getTableMetaData(each.getLogicTable(), each.getActualDataNodes(), shardingRule.getShardingDataSourceNames(), connectionMap));
    }

    private TableMetaData getTableMetaData(String logicTableName, List<DataNode> actualDataNodes, ShardingDataSourceNames shardingDataSourceNames, Map<String, Connection> connectionMap) throws SQLException {
        Collection<ColumnMetaData> result = null;
        for (DataNode each : actualDataNodes) {
            Collection<ColumnMetaData> columnMetaDataList = this.getColumnMetaDataList(each, shardingDataSourceNames, connectionMap);
            if (null == result) {
                result = columnMetaDataList;
            }
            if (result.equals(columnMetaDataList)) continue;
            throw new ShardingException(this.getErrorMsgOfTableMetaData(logicTableName, result, columnMetaDataList), new Object[0]);
        }
        return new TableMetaData(result);
    }

    public abstract Collection<ColumnMetaData> getColumnMetaDataList(DataNode var1, ShardingDataSourceNames var2, Map<String, Connection> var3) throws SQLException;

    private String getErrorMsgOfTableMetaData(String logicTableName, Collection<ColumnMetaData> oldColumnMetaDataList, Collection<ColumnMetaData> newColumnMetaDataList) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" Cannot get uniformed table structure for ").append(logicTableName).append(".");
        stringBuilder.append(" The different column metadata of actual tables is as follows: ");
        for (ColumnMetaData each : oldColumnMetaDataList) {
            stringBuilder.append(each.toString()).append(" ");
        }
        stringBuilder.append("\n");
        for (ColumnMetaData each : newColumnMetaDataList) {
            stringBuilder.append(each.toString()).append(" ");
        }
        return stringBuilder.toString();
    }

    public Map<String, TableMetaData> getTableMetaDataMap() {
        return this.tableMetaDataMap;
    }

    public void setTableMetaDataMap(Map<String, TableMetaData> tableMetaDataMap) {
        this.tableMetaDataMap = tableMetaDataMap;
    }
}

