/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.clause;

import com.google.common.base.Optional;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.Assist;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.token.InsertColumnToken;
import io.shardingsphere.core.parsing.parser.token.ItemsToken;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.util.SQLUtil;
import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.List;

public final class InsertColumnsClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;

    public void parse(InsertStatement insertStatement, ShardingMetaData shardingMetaData) {
        LinkedList<Column> result = new LinkedList<Column>();
        String tableName = insertStatement.getTables().getSingleTableName();
        Optional<Column> generateKeyColumn = this.shardingRule.getGenerateKeyColumn(tableName);
        int count = 0;
        if (this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) {
            do {
                this.lexerEngine.nextToken();
                String columnName = SQLUtil.getExactlyValue(this.lexerEngine.getCurrentToken().getLiterals());
                result.add(new Column(columnName, tableName));
                this.lexerEngine.nextToken();
                if (generateKeyColumn.isPresent() && ((Column)generateKeyColumn.get()).getName().equalsIgnoreCase(columnName)) {
                    insertStatement.setGenerateKeyColumnIndex(count);
                }
                ++count;
            } while (!this.lexerEngine.equalAny(Symbol.RIGHT_PAREN) && !this.lexerEngine.equalAny(Assist.END));
            insertStatement.setColumnsListLastPosition(this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length());
            this.lexerEngine.nextToken();
        } else {
            List<String> columnNames = shardingMetaData.getTableMetaDataMap().get(tableName).getAllColumnNames();
            int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length() - 1;
            insertStatement.getSqlTokens().add(new InsertColumnToken(beginPosition, "("));
            ItemsToken columnsToken = new ItemsToken(beginPosition);
            columnsToken.setFirstOfItemsSpecial(true);
            for (String columnName : columnNames) {
                result.add(new Column(columnName, tableName));
                if (generateKeyColumn.isPresent() && ((Column)generateKeyColumn.get()).getName().equalsIgnoreCase(columnName)) {
                    insertStatement.setGenerateKeyColumnIndex(count);
                }
                columnsToken.getItems().add(columnName);
                ++count;
            }
            insertStatement.getSqlTokens().add(columnsToken);
            insertStatement.getSqlTokens().add(new InsertColumnToken(beginPosition, ")"));
            insertStatement.setColumnsListLastPosition(beginPosition);
        }
        insertStatement.getColumns().addAll(result);
    }

    @ConstructorProperties(value={"shardingRule", "lexerEngine"})
    public InsertColumnsClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
    }
}

