/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.clause;

import io.shardingsphere.core.constant.OrderDirection;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.dialect.oracle.OracleKeyword;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.clause.expression.BasicExpressionParser;
import io.shardingsphere.core.parsing.parser.context.OrderItem;
import io.shardingsphere.core.parsing.parser.dialect.ExpressionParserFactory;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingException;
import io.shardingsphere.core.parsing.parser.expression.SQLExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLIdentifierExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLIgnoreExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLNumberExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLPropertyExpression;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.util.SQLUtil;
import java.util.LinkedList;

public class OrderByClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public OrderByClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public final void parse(SelectStatement selectStatement) {
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.ORDER)) {
            return;
        }
        LinkedList<OrderItem> result = new LinkedList<OrderItem>();
        this.lexerEngine.skipIfEqual(OracleKeyword.SIBLINGS);
        this.lexerEngine.accept(DefaultKeyword.BY);
        do {
            result.add(this.parseSelectOrderByItem(selectStatement));
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        selectStatement.getOrderByItems().addAll(result);
    }

    private OrderItem parseSelectOrderByItem(SelectStatement selectStatement) {
        SQLExpression sqlExpression = this.basicExpressionParser.parse(selectStatement);
        OrderDirection orderDirection = OrderDirection.ASC;
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.ASC)) {
            orderDirection = OrderDirection.ASC;
        } else if (this.lexerEngine.skipIfEqual(DefaultKeyword.DESC)) {
            orderDirection = OrderDirection.DESC;
        }
        if (sqlExpression instanceof SQLNumberExpression) {
            return new OrderItem(((SQLNumberExpression)sqlExpression).getNumber().intValue(), orderDirection, this.getNullOrderDirection());
        }
        if (sqlExpression instanceof SQLIdentifierExpression) {
            return new OrderItem(SQLUtil.getExactlyValue(((SQLIdentifierExpression)sqlExpression).getName()), orderDirection, this.getNullOrderDirection(), selectStatement.getAlias(SQLUtil.getExactlyValue(((SQLIdentifierExpression)sqlExpression).getName())));
        }
        if (sqlExpression instanceof SQLPropertyExpression) {
            SQLPropertyExpression sqlPropertyExpression = (SQLPropertyExpression)sqlExpression;
            return new OrderItem(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()), SQLUtil.getExactlyValue(sqlPropertyExpression.getName()), orderDirection, this.getNullOrderDirection(), selectStatement.getAlias(SQLUtil.getExactlyValue(sqlPropertyExpression.getOwner().getName()) + "." + SQLUtil.getExactlyValue(sqlPropertyExpression.getName())));
        }
        if (sqlExpression instanceof SQLIgnoreExpression) {
            SQLIgnoreExpression sqlIgnoreExpression = (SQLIgnoreExpression)sqlExpression;
            return new OrderItem(sqlIgnoreExpression.getExpression(), orderDirection, this.getNullOrderDirection(), selectStatement.getAlias(sqlIgnoreExpression.getExpression()));
        }
        throw new SQLParsingException(this.lexerEngine);
    }

    protected OrderDirection getNullOrderDirection() {
        return OrderDirection.ASC;
    }

    public LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }
}

