/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.ddl.truncate;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.sql.MySQLTruncateParser;
import io.shardingsphere.core.parsing.parser.dialect.oracle.sql.OracleTruncateParser;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.sql.PostgreSQLTruncateParser;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.sql.SQLServerTruncateParser;
import io.shardingsphere.core.parsing.parser.sql.ddl.truncate.AbstractTruncateParser;
import io.shardingsphere.core.rule.ShardingRule;

public final class TruncateParserFactory {
    public static AbstractTruncateParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLTruncateParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleTruncateParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerTruncateParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLTruncateParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private TruncateParserFactory() {
    }
}

