/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.token;

import io.shardingsphere.core.parsing.parser.token.SQLToken;
import io.shardingsphere.core.util.SQLUtil;
import java.beans.ConstructorProperties;

public final class TableToken
implements SQLToken {
    private final int beginPosition;
    private final int skippedSchemaNameLength;
    private final String originalLiterals;

    public String getTableName() {
        return SQLUtil.getExactlyValue(this.originalLiterals);
    }

    @ConstructorProperties(value={"beginPosition", "skippedSchemaNameLength", "originalLiterals"})
    public TableToken(int beginPosition, int skippedSchemaNameLength, String originalLiterals) {
        this.beginPosition = beginPosition;
        this.skippedSchemaNameLength = skippedSchemaNameLength;
        this.originalLiterals = originalLiterals;
    }

    @Override
    public int getBeginPosition() {
        return this.beginPosition;
    }

    public int getSkippedSchemaNameLength() {
        return this.skippedSchemaNameLength;
    }

    public String getOriginalLiterals() {
        return this.originalLiterals;
    }

    public String toString() {
        return "TableToken(beginPosition=" + this.getBeginPosition() + ", skippedSchemaNameLength=" + this.getSkippedSchemaNameLength() + ", originalLiterals=" + this.getOriginalLiterals() + ")";
    }
}

