/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.router.sharding;

import io.shardingsphere.core.parsing.SQLJudgeEngine;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.routing.SQLExecutionUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.SQLUnit;
import io.shardingsphere.core.routing.router.sharding.ShardingRouter;
import io.shardingsphere.core.routing.strategy.hint.HintShardingStrategy;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.routing.type.hint.DatabaseHintRoutingEngine;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.util.SQLLogger;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DatabaseHintSQLRouter
implements ShardingRouter {
    private final ShardingRule shardingRule;
    private final boolean showSQL;

    @Override
    public SQLStatement parse(String logicSQL, boolean useCache) {
        return new SQLJudgeEngine(logicSQL).judge();
    }

    @Override
    public SQLRouteResult route(String logicSQL, List<Object> parameters, SQLStatement sqlStatement) {
        SQLRouteResult result = new SQLRouteResult(sqlStatement, null);
        RoutingResult routingResult = new DatabaseHintRoutingEngine(this.shardingRule.getShardingDataSourceNames().getDataSourceNames(), (HintShardingStrategy)this.shardingRule.getDefaultDatabaseShardingStrategy()).route();
        for (TableUnit each : routingResult.getTableUnits().getTableUnits()) {
            result.getExecutionUnits().add(new SQLExecutionUnit(each.getDataSourceName(), new SQLUnit(logicSQL, new ArrayList<List<Object>>(Collections.singleton(parameters)))));
        }
        if (this.showSQL) {
            SQLLogger.logSQL(logicSQL, sqlStatement, result.getExecutionUnits());
        }
        return result;
    }

    @ConstructorProperties(value={"shardingRule", "showSQL"})
    public DatabaseHintSQLRouter(ShardingRule shardingRule, boolean showSQL) {
        this.shardingRule = shardingRule;
        this.showSQL = showSQL;
    }
}

