/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.type.standard;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.core.api.algorithm.sharding.ShardingValue;
import io.shardingsphere.core.hint.HintManagerHolder;
import io.shardingsphere.core.hint.ShardingKey;
import io.shardingsphere.core.optimizer.condition.ShardingCondition;
import io.shardingsphere.core.optimizer.condition.ShardingConditions;
import io.shardingsphere.core.optimizer.insert.InsertShardingCondition;
import io.shardingsphere.core.routing.type.RoutingEngine;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.RoutingTable;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public final class StandardRoutingEngine
implements RoutingEngine {
    private final ShardingRule shardingRule;
    private final String logicTableName;
    private final ShardingConditions shardingConditions;

    @Override
    public RoutingResult route() {
        TableRule tableRule = this.shardingRule.getTableRule(this.logicTableName);
        Collection<String> databaseShardingColumns = this.shardingRule.getDatabaseShardingStrategy(tableRule).getShardingColumns();
        Collection<String> tableShardingColumns = this.shardingRule.getTableShardingStrategy(tableRule).getShardingColumns();
        LinkedHashSet<DataNode> routedDataNodes = new LinkedHashSet<DataNode>();
        if (HintManagerHolder.isUseShardingHint()) {
            List<ShardingValue> databaseShardingValues = this.getDatabaseShardingValuesFromHint(databaseShardingColumns);
            List<ShardingValue> tableShardingValues = this.getTableShardingValuesFromHint(tableShardingColumns);
            Collection<DataNode> dataNodes = this.route(tableRule, databaseShardingValues, tableShardingValues);
            for (ShardingCondition each : this.shardingConditions.getShardingConditions()) {
                if (!(each instanceof InsertShardingCondition)) continue;
                ((InsertShardingCondition)each).getDataNodes().addAll(dataNodes);
            }
            routedDataNodes.addAll(dataNodes);
        } else if (this.shardingConditions.getShardingConditions().isEmpty()) {
            routedDataNodes.addAll(this.route(tableRule, Collections.emptyList(), Collections.emptyList()));
        } else {
            for (ShardingCondition each : this.shardingConditions.getShardingConditions()) {
                List<ShardingValue> databaseShardingValues = this.getShardingValues(databaseShardingColumns, each);
                List<ShardingValue> tableShardingValues = this.getShardingValues(tableShardingColumns, each);
                Collection<DataNode> dataNodes = this.route(tableRule, databaseShardingValues, tableShardingValues);
                routedDataNodes.addAll(dataNodes);
                if (!(each instanceof InsertShardingCondition)) continue;
                ((InsertShardingCondition)each).getDataNodes().addAll(dataNodes);
            }
        }
        return this.generateRoutingResult(routedDataNodes);
    }

    private Collection<DataNode> route(TableRule tableRule, List<ShardingValue> databaseShardingValues, List<ShardingValue> tableShardingValues) {
        Collection<String> routedDataSources = this.routeDataSources(tableRule, databaseShardingValues);
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : routedDataSources) {
            result.addAll(this.routeTables(tableRule, each, tableShardingValues));
        }
        return result;
    }

    private List<ShardingValue> getDatabaseShardingValuesFromHint(Collection<String> shardingColumns) {
        ArrayList<ShardingValue> result = new ArrayList<ShardingValue>(shardingColumns.size());
        for (String each : shardingColumns) {
            Optional<ShardingValue> shardingValue = HintManagerHolder.getDatabaseShardingValue(new ShardingKey(this.logicTableName, each));
            if (!shardingValue.isPresent()) continue;
            result.add((ShardingValue)shardingValue.get());
        }
        return result;
    }

    private List<ShardingValue> getTableShardingValuesFromHint(Collection<String> shardingColumns) {
        ArrayList<ShardingValue> result = new ArrayList<ShardingValue>(shardingColumns.size());
        for (String each : shardingColumns) {
            Optional<ShardingValue> shardingValue = HintManagerHolder.getTableShardingValue(new ShardingKey(this.logicTableName, each));
            if (!shardingValue.isPresent()) continue;
            result.add((ShardingValue)shardingValue.get());
        }
        return result;
    }

    private List<ShardingValue> getShardingValues(Collection<String> shardingColumns, ShardingCondition shardingCondition) {
        ArrayList<ShardingValue> result = new ArrayList<ShardingValue>(shardingColumns.size());
        for (ShardingValue each : shardingCondition.getShardingValues()) {
            if (!this.logicTableName.equals(each.getLogicTableName()) || !shardingColumns.contains(each.getColumnName())) continue;
            result.add(each);
        }
        return result;
    }

    private Collection<String> routeDataSources(TableRule tableRule, List<ShardingValue> databaseShardingValues) {
        Collection<String> availableTargetDatabases = tableRule.getActualDatasourceNames();
        if (databaseShardingValues.isEmpty()) {
            return availableTargetDatabases;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.shardingRule.getDatabaseShardingStrategy(tableRule).doSharding(availableTargetDatabases, databaseShardingValues));
        Preconditions.checkState((!result.isEmpty() ? 1 : 0) != 0, (Object)"no database route info");
        return result;
    }

    private Collection<DataNode> routeTables(TableRule tableRule, String routedDataSource, List<ShardingValue> tableShardingValues) {
        Collection<String> availableTargetTables = tableRule.getActualTableNames(routedDataSource);
        LinkedHashSet<String> routedTables = new LinkedHashSet<String>(tableShardingValues.isEmpty() ? availableTargetTables : this.shardingRule.getTableShardingStrategy(tableRule).doSharding(availableTargetTables, tableShardingValues));
        Preconditions.checkState((!routedTables.isEmpty() ? 1 : 0) != 0, (Object)"no table route info");
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : routedTables) {
            result.add(new DataNode(routedDataSource, each));
        }
        return result;
    }

    private RoutingResult generateRoutingResult(Collection<DataNode> routedDataNodes) {
        RoutingResult result = new RoutingResult();
        for (DataNode each : routedDataNodes) {
            TableUnit tableUnit = new TableUnit(each.getDataSourceName());
            tableUnit.getRoutingTables().add(new RoutingTable(this.logicTableName, each.getTableName()));
            result.getTableUnits().getTableUnits().add(tableUnit);
        }
        return result;
    }

    @ConstructorProperties(value={"shardingRule", "logicTableName", "shardingConditions"})
    public StandardRoutingEngine(ShardingRule shardingRule, String logicTableName, ShardingConditions shardingConditions) {
        this.shardingRule = shardingRule;
        this.logicTableName = logicTableName;
        this.shardingConditions = shardingConditions;
    }
}

