/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import groovy.lang.GString;
import groovy.lang.GroovyShell;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class InlineExpressionParser {
    private static final char SPLITTER = ',';
    private final String inlineExpression;

    public static String handlePlaceHolder(String inlineExpression) {
        return inlineExpression.contains("$->{") ? inlineExpression.replaceAll("\\$->\\{", "\\$\\{") : inlineExpression;
    }

    public List<String> evaluate() {
        if (null == this.inlineExpression) {
            return Collections.emptyList();
        }
        return this.flatten(this.evaluate(this.split()));
    }

    private List<Object> evaluate(List<String> inlineExpressions) {
        ArrayList<Object> result = new ArrayList<Object>(inlineExpressions.size());
        GroovyShell shell = new GroovyShell();
        for (String each : inlineExpressions) {
            StringBuilder expression = new StringBuilder(InlineExpressionParser.handlePlaceHolder(each));
            if (!each.startsWith("\"")) {
                expression.insert(0, "\"");
            }
            if (!each.endsWith("\"")) {
                expression.append("\"");
            }
            result.add(shell.evaluate(expression.toString()));
        }
        return result;
    }

    private List<String> split() {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder segment = new StringBuilder();
        int bracketsDepth = 0;
        block5: for (int i = 0; i < this.inlineExpression.length(); ++i) {
            char each = this.inlineExpression.charAt(i);
            switch (each) {
                case ',': {
                    if (bracketsDepth > 0) {
                        segment.append(each);
                        continue block5;
                    }
                    result.add(segment.toString().trim());
                    segment.setLength(0);
                    continue block5;
                }
                case '$': {
                    if ('{' == this.inlineExpression.charAt(i + 1)) {
                        ++bracketsDepth;
                    }
                    if ("->{".equals(this.inlineExpression.substring(i + 1, i + 4))) {
                        ++bracketsDepth;
                    }
                    segment.append(each);
                    continue block5;
                }
                case '}': {
                    if (bracketsDepth > 0) {
                        --bracketsDepth;
                    }
                    segment.append(each);
                    continue block5;
                }
                default: {
                    segment.append(each);
                }
            }
        }
        if (segment.length() > 0) {
            result.add(segment.toString().trim());
        }
        return result;
    }

    private List<String> flatten(List<Object> segments) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object each : segments) {
            if (each instanceof GString) {
                result.addAll(this.assemblyCartesianSegments((GString)each));
                continue;
            }
            result.add(each.toString());
        }
        return result;
    }

    private List<String> assemblyCartesianSegments(GString segment) {
        Set<List<String>> cartesianValues = this.getCartesianValues(segment);
        ArrayList<String> result = new ArrayList<String>(cartesianValues.size());
        for (List<String> each : cartesianValues) {
            result.add(this.assemblySegment(each, segment));
        }
        return result;
    }

    private Set<List<String>> getCartesianValues(GString segment) {
        ArrayList<HashSet> result = new ArrayList<HashSet>(segment.getValues().length);
        for (Object each : segment.getValues()) {
            if (null == each) continue;
            if (each instanceof Collection) {
                result.add(Sets.newLinkedHashSet((Iterable)Collections2.transform((Collection)((Collection)each), (Function)new Function<Object, String>(){

                    public String apply(Object input) {
                        return input.toString();
                    }
                })));
                continue;
            }
            result.add(Sets.newHashSet((Object[])new String[]{each.toString()}));
        }
        return Sets.cartesianProduct(result);
    }

    private String assemblySegment(List<String> cartesianValue, GString segment) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < segment.getStrings().length; ++i) {
            result.append(segment.getStrings()[i]);
            if (i >= cartesianValue.size()) continue;
            result.append(cartesianValue.get(i));
        }
        return result.toString();
    }

    @ConstructorProperties(value={"inlineExpression"})
    public InlineExpressionParser(String inlineExpression) {
        this.inlineExpression = inlineExpression;
    }
}

