/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.sql.execute.threadlocal;

import io.shardingsphere.core.exception.ShardingException;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExecutorExceptionHandler.class);
    private static final ThreadLocal<Boolean> IS_EXCEPTION_THROWN = new ThreadLocal();

    public static void setExceptionThrown(boolean isExceptionThrown) {
        IS_EXCEPTION_THROWN.set(isExceptionThrown);
    }

    public static boolean isExceptionThrown() {
        return null == IS_EXCEPTION_THROWN.get() ? true : IS_EXCEPTION_THROWN.get();
    }

    public static void handleException(Exception exception) throws SQLException {
        if (ExecutorExceptionHandler.isExceptionThrown()) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw new ShardingException(exception);
        }
        log.error("exception occur: ", (Throwable)exception);
    }

    private ExecutorExceptionHandler() {
    }
}

