/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.hint;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.shardingsphere.api.HintManager;
import io.shardingsphere.api.algorithm.sharding.ListShardingValue;
import io.shardingsphere.api.algorithm.sharding.ShardingValue;
import java.util.Collection;

public final class HintManagerHolder {
    public static final String DB_TABLE_NAME = "DB_TABLE_NAME";
    public static final String DB_COLUMN_NAME = "DB_COLUMN_NAME";
    private static final ThreadLocal<HintManager> HINT_MANAGER_HOLDER = new ThreadLocal();
    private static final Multimap<String, Comparable<?>> DATABASE_SHARDING_VALUES = HashMultimap.create();
    private static final Multimap<String, Comparable<?>> TABLE_SHARDING_VALUES = HashMultimap.create();
    private static boolean databaseShardingOnly;
    private static boolean isMasterRouteOnly;

    public static void setHintManager(HintManager hintManager) {
        Preconditions.checkState((null == HINT_MANAGER_HOLDER.get() ? 1 : 0) != 0, (Object)"HintManagerHolder has previous value, please clear first.");
        HINT_MANAGER_HOLDER.set(hintManager);
    }

    public static void setDatabaseShardingValue(Comparable<?> value) {
        DATABASE_SHARDING_VALUES.clear();
        HintManagerHolder.addDatabaseShardingValue(DB_TABLE_NAME, value);
        databaseShardingOnly = true;
    }

    public static void addDatabaseShardingValue(String logicTable, Comparable<?> value) {
        DATABASE_SHARDING_VALUES.put((Object)logicTable, value);
        databaseShardingOnly = false;
    }

    public static void addTableShardingValue(String logicTable, Comparable<?> value) {
        TABLE_SHARDING_VALUES.put((Object)logicTable, value);
        databaseShardingOnly = false;
    }

    public static boolean isDatabaseShardingOnly() {
        return null != HINT_MANAGER_HOLDER.get() && databaseShardingOnly;
    }

    public static boolean isMasterRouteOnly() {
        return null != HINT_MANAGER_HOLDER.get() && isMasterRouteOnly;
    }

    public static Optional<ShardingValue> getDatabaseShardingValue(String logicTable) {
        if (null == HINT_MANAGER_HOLDER.get() || !DATABASE_SHARDING_VALUES.containsKey((Object)logicTable)) {
            return Optional.absent();
        }
        return Optional.of((Object)HintManagerHolder.getShardingValue(logicTable, DATABASE_SHARDING_VALUES.get((Object)logicTable)));
    }

    public static Optional<ShardingValue> getTableShardingValue(String logicTable) {
        if (null == HINT_MANAGER_HOLDER.get() || !TABLE_SHARDING_VALUES.containsKey((Object)logicTable)) {
            return Optional.absent();
        }
        return Optional.of((Object)HintManagerHolder.getShardingValue(logicTable, TABLE_SHARDING_VALUES.get((Object)logicTable)));
    }

    private static ShardingValue getShardingValue(String logicTable, Collection<Comparable<?>> values) {
        Preconditions.checkArgument((null != values && !values.isEmpty() ? 1 : 0) != 0);
        return new ListShardingValue(logicTable, DB_COLUMN_NAME, values);
    }

    public static HintManager get() {
        return HINT_MANAGER_HOLDER.get();
    }

    public static void clear() {
        HINT_MANAGER_HOLDER.remove();
        DATABASE_SHARDING_VALUES.clear();
        TABLE_SHARDING_VALUES.clear();
        databaseShardingOnly = false;
        isMasterRouteOnly = false;
    }

    private HintManagerHolder() {
    }

    public static void setDatabaseShardingOnly(boolean databaseShardingOnly) {
        HintManagerHolder.databaseShardingOnly = databaseShardingOnly;
    }

    public static void setMasterRouteOnly(boolean isMasterRouteOnly) {
        HintManagerHolder.isMasterRouteOnly = isMasterRouteOnly;
    }
}

