/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.clause;

import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.clause.TableReferencesClauseParser;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import java.beans.ConstructorProperties;

public abstract class InsertIntoClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public void parse(InsertStatement insertStatement) {
        this.lexerEngine.unsupportedIfEqual(this.getUnsupportedKeywordsBeforeInto());
        this.lexerEngine.skipUntil(DefaultKeyword.INTO);
        this.lexerEngine.nextToken();
        this.tableReferencesClauseParser.parse(insertStatement, true);
        this.skipBetweenTableAndValues(insertStatement);
    }

    protected abstract Keyword[] getUnsupportedKeywordsBeforeInto();

    private void skipBetweenTableAndValues(InsertStatement insertStatement) {
        while (this.lexerEngine.skipIfEqual(this.getSkippedKeywordsBetweenTableAndValues())) {
            this.lexerEngine.nextToken();
            if (!this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) continue;
            this.lexerEngine.skipParentheses(insertStatement);
        }
    }

    protected abstract Keyword[] getSkippedKeywordsBetweenTableAndValues();

    @ConstructorProperties(value={"lexerEngine", "tableReferencesClauseParser"})
    public InsertIntoClauseParser(LexerEngine lexerEngine, TableReferencesClauseParser tableReferencesClauseParser) {
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = tableReferencesClauseParser;
    }
}

