/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.dialect.mysql.clause;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.dialect.mysql.MySQLKeyword;
import io.shardingsphere.core.parsing.lexer.token.Literals;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.context.limit.Limit;
import io.shardingsphere.core.parsing.parser.context.limit.LimitValue;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingException;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.parsing.parser.token.OffsetToken;
import io.shardingsphere.core.parsing.parser.token.RowCountToken;
import java.beans.ConstructorProperties;

public final class MySQLLimitClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;

    public void parse(SelectStatement selectStatement) {
        int value;
        if (!this.lexerEngine.skipIfEqual(MySQLKeyword.LIMIT)) {
            return;
        }
        int valueIndex = -1;
        int valueBeginPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        boolean isParameterForValue = false;
        if (this.lexerEngine.equalAny(Literals.INT)) {
            value = Integer.parseInt(this.lexerEngine.getCurrentToken().getLiterals());
            valueBeginPosition -= (value + "").length();
        } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
            valueIndex = selectStatement.getParametersIndex();
            value = -1;
            --valueBeginPosition;
            isParameterForValue = true;
        } else {
            throw new SQLParsingException(this.lexerEngine);
        }
        this.lexerEngine.nextToken();
        if (this.lexerEngine.skipIfEqual(Symbol.COMMA)) {
            selectStatement.setLimit(this.getLimitWithComma(valueIndex, valueBeginPosition, value, isParameterForValue, selectStatement));
            return;
        }
        if (this.lexerEngine.skipIfEqual(MySQLKeyword.OFFSET)) {
            selectStatement.setLimit(this.getLimitWithOffset(valueIndex, valueBeginPosition, value, isParameterForValue, selectStatement));
            return;
        }
        if (isParameterForValue) {
            selectStatement.increaseParametersIndex();
        } else {
            selectStatement.addSQLToken(new RowCountToken(valueBeginPosition, value));
        }
        Limit limit = new Limit(DatabaseType.MySQL);
        limit.setRowCount(new LimitValue(value, valueIndex, false));
        selectStatement.setLimit(limit);
    }

    private Limit getLimitWithComma(int index, int valueBeginPosition, int value, boolean isParameterForValue, SelectStatement selectStatement) {
        int rowCountValue;
        int rowCountBeginPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        int rowCountIndex = -1;
        boolean isParameterForRowCount = false;
        if (this.lexerEngine.equalAny(Literals.INT)) {
            rowCountValue = Integer.parseInt(this.lexerEngine.getCurrentToken().getLiterals());
            rowCountBeginPosition -= (rowCountValue + "").length();
        } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
            rowCountIndex = -1 == index ? selectStatement.getParametersIndex() : index + 1;
            rowCountValue = -1;
            --rowCountBeginPosition;
            isParameterForRowCount = true;
        } else {
            throw new SQLParsingException(this.lexerEngine);
        }
        this.lexerEngine.nextToken();
        if (isParameterForValue) {
            selectStatement.increaseParametersIndex();
        } else {
            selectStatement.addSQLToken(new OffsetToken(valueBeginPosition, value));
        }
        if (isParameterForRowCount) {
            selectStatement.increaseParametersIndex();
        } else {
            selectStatement.addSQLToken(new RowCountToken(rowCountBeginPosition, rowCountValue));
        }
        Limit result = new Limit(DatabaseType.MySQL);
        result.setRowCount(new LimitValue(rowCountValue, rowCountIndex, false));
        result.setOffset(new LimitValue(value, index, true));
        return result;
    }

    private Limit getLimitWithOffset(int index, int valueBeginPosition, int value, boolean isParameterForValue, SelectStatement selectStatement) {
        int offsetBeginPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        int offsetValue = -1;
        int offsetIndex = -1;
        boolean isParameterForOffset = false;
        if (this.lexerEngine.equalAny(Literals.INT)) {
            offsetValue = Integer.parseInt(this.lexerEngine.getCurrentToken().getLiterals());
            offsetBeginPosition -= (offsetValue + "").length();
        } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
            offsetIndex = -1 == index ? selectStatement.getParametersIndex() : index + 1;
            --offsetBeginPosition;
            isParameterForOffset = true;
        } else {
            throw new SQLParsingException(this.lexerEngine);
        }
        this.lexerEngine.nextToken();
        if (isParameterForOffset) {
            selectStatement.increaseParametersIndex();
        } else {
            selectStatement.addSQLToken(new OffsetToken(offsetBeginPosition, offsetValue));
        }
        if (isParameterForValue) {
            selectStatement.increaseParametersIndex();
        } else {
            selectStatement.addSQLToken(new RowCountToken(valueBeginPosition, value));
        }
        Limit result = new Limit(DatabaseType.MySQL);
        result.setRowCount(new LimitValue(value, index, false));
        result.setOffset(new LimitValue(offsetValue, offsetIndex, true));
        return result;
    }

    @ConstructorProperties(value={"lexerEngine"})
    public MySQLLimitClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
    }
}

