/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.ddl.create.index;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.sql.MySQLCreateIndexParser;
import io.shardingsphere.core.parsing.parser.dialect.oracle.sql.OracleCreateIndexParser;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.sql.PostgreSQLCreateIndexParser;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.sql.SQLServerCreateIndexParser;
import io.shardingsphere.core.parsing.parser.sql.ddl.create.index.AbstractCreateIndexParser;
import io.shardingsphere.core.rule.ShardingRule;

public final class CreateIndexParserFactory {
    public static AbstractCreateIndexParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLCreateIndexParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleCreateIndexParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerCreateIndexParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLCreateIndexParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private CreateIndexParserFactory() {
    }
}

