/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.dql.select;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.sql.MySQLSelectParser;
import io.shardingsphere.core.parsing.parser.dialect.oracle.sql.OracleSelectParser;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.sql.PostgreSQLSelectParser;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.sql.SQLServerSelectParser;
import io.shardingsphere.core.parsing.parser.sql.dql.select.AbstractSelectParser;
import io.shardingsphere.core.rule.ShardingRule;

public final class SelectParserFactory {
    public static AbstractSelectParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine, ShardingTableMetaData shardingTableMetaData) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLSelectParser(shardingRule, lexerEngine, shardingTableMetaData);
            }
            case Oracle: {
                return new OracleSelectParser(shardingRule, lexerEngine, shardingTableMetaData);
            }
            case SQLServer: {
                return new SQLServerSelectParser(shardingRule, lexerEngine, shardingTableMetaData);
            }
            case PostgreSQL: {
                return new PostgreSQLSelectParser(shardingRule, lexerEngine, shardingTableMetaData);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private SelectParserFactory() {
    }
}

