/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger.dal.show;

import com.google.common.base.Optional;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.merger.dql.common.MemoryMergedResult;
import io.shardingsphere.core.merger.dql.common.MemoryQueryResultRow;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class LogicTablesMergedResult
extends MemoryMergedResult {
    private final ShardingRule shardingRule;
    private final Iterator<MemoryQueryResultRow> memoryResultSetRows;
    private final Set<String> tableNames = new HashSet<String>();
    private final ShardingTableMetaData shardingTableMetaData;

    public LogicTablesMergedResult(Map<String, Integer> labelAndIndexMap, ShardingRule shardingRule, List<QueryResult> queryResults, ShardingTableMetaData shardingTableMetaData) throws SQLException {
        super(labelAndIndexMap);
        this.shardingRule = shardingRule;
        this.shardingTableMetaData = shardingTableMetaData;
        this.memoryResultSetRows = this.init(queryResults);
    }

    private Iterator<MemoryQueryResultRow> init(List<QueryResult> queryResults) throws SQLException {
        LinkedList<MemoryQueryResultRow> result = new LinkedList<MemoryQueryResultRow>();
        for (QueryResult each : queryResults) {
            while (each.next()) {
                MemoryQueryResultRow memoryResultSetRow = new MemoryQueryResultRow(each);
                String actualTableName = memoryResultSetRow.getCell(1).toString();
                Optional<TableRule> tableRule = this.shardingRule.findTableRuleByActualTable(actualTableName);
                if (!tableRule.isPresent()) {
                    if (!this.shardingRule.getTableRules().isEmpty() && (!this.shardingTableMetaData.containsTable(actualTableName) || !this.tableNames.add(actualTableName))) continue;
                    result.add(memoryResultSetRow);
                    continue;
                }
                if (!this.tableNames.add(((TableRule)tableRule.get()).getLogicTable())) continue;
                memoryResultSetRow.setCell(1, ((TableRule)tableRule.get()).getLogicTable());
                this.setCellValue(memoryResultSetRow, ((TableRule)tableRule.get()).getLogicTable(), actualTableName);
                result.add(memoryResultSetRow);
            }
        }
        if (!result.isEmpty()) {
            this.setCurrentResultSetRow((MemoryQueryResultRow)result.get(0));
        }
        return result.iterator();
    }

    protected void setCellValue(MemoryQueryResultRow memoryResultSetRow, String logicTableName, String actualTableName) {
    }

    @Override
    public final boolean next() {
        if (this.memoryResultSetRows.hasNext()) {
            this.setCurrentResultSetRow(this.memoryResultSetRows.next());
            return true;
        }
        return false;
    }
}

