/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.column.ColumnSegment;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.util.SQLUtil;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;

public final class ColumnSegmentExtractor
implements OptionalSQLSegmentExtractor {
    private final Map<String, String> tableAlias;

    public Optional<ColumnSegment> extract(ParserRuleContext ancestorNode) {
        Optional ownerName;
        Optional<ParserRuleContext> columnNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.COLUMN_NAME);
        if (!columnNode.isPresent()) {
            return Optional.absent();
        }
        String columnText = ((ParserRuleContext)columnNode.get()).getText();
        int dotPosition = columnText.contains(Symbol.DOT.getLiterals()) ? columnText.lastIndexOf(Symbol.DOT.getLiterals()) : 0;
        String columnName = columnText;
        String tableName = "";
        if (0 < dotPosition) {
            columnName = columnText.substring(dotPosition + 1);
            ownerName = Optional.of((Object)SQLUtil.getExactlyValue(columnText.substring(0, dotPosition)));
            tableName = this.tableAlias.get(ownerName.get());
        } else {
            ownerName = Optional.absent();
        }
        if ("".equals(tableName) && 1 == this.tableAlias.size()) {
            tableName = this.tableAlias.values().iterator().next();
        }
        columnName = SQLUtil.getExactlyValue(columnName);
        return Optional.of((Object)new ColumnSegment((Optional<String>)ownerName, columnName, tableName, ((ParserRuleContext)columnNode.get()).getStart().getStartIndex()));
    }

    @ConstructorProperties(value={"tableAlias"})
    public ColumnSegmentExtractor(Map<String, String> tableAlias) {
        this.tableAlias = tableAlias;
    }
}

