/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.PredicateExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.TableNameExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.FromWhereSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.condition.OrConditionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.table.TableJoinSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.table.TableSegment;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

public final class FromWhereExtractor
implements OptionalSQLSegmentExtractor {
    private final TableNameExtractor tableNameExtractor = new TableNameExtractor();
    private PredicateExtractor predicateSegmentExtractor;

    public Optional<FromWhereSegment> extract(ParserRuleContext ancestorNode) {
        return this.extract(ancestorNode, ancestorNode);
    }

    public Optional<FromWhereSegment> extract(ParserRuleContext ancestorNode, ParserRuleContext rootNode) {
        Optional<ParserRuleContext> selectClauseNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.SELECT_CLAUSE);
        if (!selectClauseNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ParserRuleContext> fromNode = ExtractorUtils.findFirstChildNodeNoneRecursive(((ParserRuleContext)selectClauseNode.get()).getParent(), RuleName.FROM_CLAUSE);
        if (!fromNode.isPresent()) {
            return Optional.absent();
        }
        Collection<ParserRuleContext> tableReferenceNodes = ExtractorUtils.getAllDescendantNodes((ParserRuleContext)fromNode.get(), RuleName.TABLE_REFERENCE);
        if (tableReferenceNodes.isEmpty()) {
            return Optional.absent();
        }
        FromWhereSegment result = new FromWhereSegment();
        this.predicateSegmentExtractor = new PredicateExtractor(result.getTableAliases());
        Collection<ParserRuleContext> questionNodes = ExtractorUtils.getAllDescendantNodes(rootNode, RuleName.QUESTION);
        result.setParameterCount(questionNodes.size());
        Map<ParserRuleContext, Integer> questionNodeIndexMap = this.getPlaceholderAndNodeIndexMap(questionNodes);
        this.extractAndFillTableSegment(result, tableReferenceNodes, questionNodeIndexMap);
        this.extractAndFillWhere(result, questionNodeIndexMap, ((ParserRuleContext)fromNode.get()).getParent());
        return Optional.of((Object)result);
    }

    private Map<ParserRuleContext, Integer> getPlaceholderAndNodeIndexMap(Collection<ParserRuleContext> questionNodes) {
        HashMap<ParserRuleContext, Integer> result = new HashMap<ParserRuleContext, Integer>(questionNodes.size(), 1.0f);
        int index = 0;
        for (ParserRuleContext each : questionNodes) {
            result.put(each, index++);
        }
        return result;
    }

    private void extractAndFillTableSegment(FromWhereSegment fromWhereSegment, Collection<ParserRuleContext> tableReferenceNodes, Map<ParserRuleContext, Integer> questionNodeIndexMap) {
        for (ParserRuleContext each : tableReferenceNodes) {
            for (int i = 0; i < each.getChildCount(); ++i) {
                if (each.getChild(i) instanceof TerminalNode) continue;
                ParserRuleContext childNode = (ParserRuleContext)each.getChild(i);
                if (RuleName.TABLE_REFERENCES.getName().equals(childNode.getClass().getSimpleName())) {
                    Collection<ParserRuleContext> subTableReferenceNodes = ExtractorUtils.getAllDescendantNodes(childNode, RuleName.TABLE_REFERENCE);
                    if (subTableReferenceNodes.isEmpty()) continue;
                    this.extractAndFillTableSegment(fromWhereSegment, subTableReferenceNodes, questionNodeIndexMap);
                    continue;
                }
                this.fillTable(fromWhereSegment, childNode, questionNodeIndexMap);
            }
        }
    }

    private void fillTable(FromWhereSegment fromWhereSegment, ParserRuleContext joinOrTableFactorNode, Map<ParserRuleContext, Integer> questionNodeIndexMap) {
        Optional<ParserRuleContext> joinConditionNode;
        if (!RuleName.JOIN_TABLE.getName().endsWith(joinOrTableFactorNode.getClass().getSimpleName())) {
            Optional<TableSegment> tableSegment = this.tableNameExtractor.extract(joinOrTableFactorNode);
            Preconditions.checkState((boolean)tableSegment.isPresent());
            this.fillTableResult(fromWhereSegment, (TableSegment)tableSegment.get());
        }
        if (!(joinConditionNode = ExtractorUtils.findFirstChildNode(joinOrTableFactorNode, RuleName.JOIN_CONDITION)).isPresent()) {
            return;
        }
        Optional<ParserRuleContext> tableFactorNode = ExtractorUtils.findFirstChildNode(joinOrTableFactorNode, RuleName.TABLE_FACTOR);
        Preconditions.checkState((boolean)tableFactorNode.isPresent());
        Optional<TableSegment> tableSegment = this.tableNameExtractor.extract((ParserRuleContext)tableFactorNode.get());
        Preconditions.checkState((boolean)tableSegment.isPresent());
        TableJoinSegment tableJoinResult = new TableJoinSegment((TableSegment)tableSegment.get());
        Optional<OrConditionSegment> conditionResult = this.buildCondition((ParserRuleContext)joinConditionNode.get(), questionNodeIndexMap);
        if (conditionResult.isPresent()) {
            tableJoinResult.getJoinConditions().getAndConditions().addAll(((OrConditionSegment)conditionResult.get()).getAndConditions());
            fromWhereSegment.getConditions().getAndConditions().addAll(((OrConditionSegment)conditionResult.get()).getAndConditions());
        }
        this.fillTableResult(fromWhereSegment, tableJoinResult);
    }

    private void fillTableResult(FromWhereSegment fromWhereSegment, TableSegment tableSegment) {
        String alias = tableSegment.getName();
        if (tableSegment.getAlias().isPresent()) {
            alias = (String)tableSegment.getAlias().get();
        }
        fromWhereSegment.getTableAliases().put(alias, tableSegment.getName());
    }

    private void extractAndFillWhere(FromWhereSegment fromWhereSegment, Map<ParserRuleContext, Integer> questionNodeIndexMap, ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> whereNode = ExtractorUtils.findFirstChildNodeNoneRecursive(ancestorNode, RuleName.WHERE_CLAUSE);
        if (!whereNode.isPresent()) {
            return;
        }
        Optional<OrConditionSegment> conditions = this.buildCondition((ParserRuleContext)((ParserRuleContext)whereNode.get()).getChild(1), questionNodeIndexMap);
        if (conditions.isPresent()) {
            fromWhereSegment.getConditions().getAndConditions().addAll(((OrConditionSegment)conditions.get()).getAndConditions());
        }
    }

    private Optional<OrConditionSegment> buildCondition(ParserRuleContext node, Map<ParserRuleContext, Integer> questionNodeIndexMap) {
        Optional<ParserRuleContext> exprNode = ExtractorUtils.findFirstChildNode(node, RuleName.EXPR);
        return exprNode.isPresent() ? this.predicateSegmentExtractor.extractCondition(questionNodeIndexMap, (ParserRuleContext)exprNode.get()) : Optional.absent();
    }
}

