/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.filler.impl.dql;

import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.filler.SQLStatementFiller;
import io.shardingsphere.core.parsing.antlr.filler.impl.FromWhereFiller;
import io.shardingsphere.core.parsing.antlr.filler.impl.dql.GroupByFiller;
import io.shardingsphere.core.parsing.antlr.filler.impl.dql.OrderByFiller;
import io.shardingsphere.core.parsing.antlr.filler.impl.dql.SelectClauseFiller;
import io.shardingsphere.core.parsing.antlr.sql.segment.FromWhereSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.SelectClauseSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.SubquerySegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.GroupBySegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.OrderBySegment;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.rule.ShardingRule;

public final class SubqueryFiller
implements SQLStatementFiller<SubquerySegment> {
    @Override
    public void fill(SubquerySegment sqlSegment, SQLStatement sqlStatement, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        SelectStatement selectStatement = (SelectStatement)sqlStatement;
        SelectStatement subqueryStatement = new SelectStatement();
        selectStatement.getSubQueryStatements().add(subqueryStatement);
        if (sqlSegment.getSelectClauseSegment().isPresent()) {
            new SelectClauseFiller().fill((SelectClauseSegment)sqlSegment.getSelectClauseSegment().get(), (SQLStatement)subqueryStatement, sql, shardingRule, shardingTableMetaData);
        }
        if (sqlSegment.getFromWhereSegment().isPresent()) {
            new FromWhereFiller().fill((FromWhereSegment)sqlSegment.getFromWhereSegment().get(), (SQLStatement)subqueryStatement, sql, shardingRule, shardingTableMetaData);
        }
        if (!sqlSegment.isSubqueryInFrom()) {
            return;
        }
        if (sqlSegment.getGroupBySegment().isPresent()) {
            new GroupByFiller().fill((GroupBySegment)sqlSegment.getGroupBySegment().get(), (SQLStatement)subqueryStatement, sql, shardingRule, shardingTableMetaData);
        }
        if (sqlSegment.getOrderBySegment().isPresent()) {
            new OrderByFiller().fill((OrderBySegment)sqlSegment.getOrderBySegment().get(), (SQLStatement)subqueryStatement, sql, shardingRule, shardingTableMetaData);
        }
    }
}

