/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.optimizer;

import com.google.common.base.Optional;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.optimizer.SQLStatementOptimizer;
import io.shardingsphere.core.parsing.antlr.rule.registry.statement.SQLStatementRule;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import java.beans.ConstructorProperties;

public final class SQLStatementOptimizerEngine {
    private final ShardingTableMetaData shardingTableMetaData;

    public void optimize(SQLStatementRule rule, SQLStatement sqlStatement) {
        Optional<SQLStatementOptimizer> optimizer = rule.getOptimizer();
        if (optimizer.isPresent()) {
            ((SQLStatementOptimizer)optimizer.get()).optimize(sqlStatement, this.shardingTableMetaData);
        }
    }

    @ConstructorProperties(value={"shardingTableMetaData"})
    public SQLStatementOptimizerEngine(ShardingTableMetaData shardingTableMetaData) {
        this.shardingTableMetaData = shardingTableMetaData;
    }
}

