/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.adapter;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.jdbc.unsupported.AbstractUnsupportedOperationDataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.logging.Logger;
import javax.sql.DataSource;

public abstract class AbstractDataSourceAdapter
extends AbstractUnsupportedOperationDataSource {
    private final DatabaseType databaseType;
    private PrintWriter logWriter = new PrintWriter(System.out);

    public AbstractDataSourceAdapter(Collection<DataSource> dataSources) throws SQLException {
        this.databaseType = this.getDatabaseType(dataSources);
    }

    protected DatabaseType getDatabaseType(Collection<DataSource> dataSources) throws SQLException {
        DatabaseType result = null;
        for (DataSource each : dataSources) {
            DatabaseType databaseType = this.getDatabaseType(each);
            Preconditions.checkState((null == result || result.equals((Object)databaseType) ? 1 : 0) != 0, (Object)String.format("Database type inconsistent with '%s' and '%s'", result, databaseType));
            result = databaseType;
        }
        return result;
    }

    private DatabaseType getDatabaseType(DataSource dataSource) throws SQLException {
        if (dataSource instanceof AbstractDataSourceAdapter) {
            return ((AbstractDataSourceAdapter)dataSource).databaseType;
        }
        try (Connection connection = dataSource.getConnection();){
            DatabaseType databaseType = DatabaseType.valueFrom((String)connection.getMetaData().getDatabaseProductName());
            return databaseType;
        }
    }

    @Override
    public final PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public final void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    @Override
    public final Logger getParentLogger() {
        return Logger.getLogger("global");
    }

    @Override
    public final Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

