/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.adapter;

import io.shardingsphere.core.jdbc.unsupported.AbstractUnsupportedOperationStatement;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;

public abstract class AbstractStatementAdapter
extends AbstractUnsupportedOperationStatement {
    private final Class<? extends Statement> targetClass;
    private boolean closed;
    private boolean poolable;
    private int fetchSize;

    @Override
    public final void close() throws SQLException {
        this.closed = true;
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (Statement statement : this.getRoutedStatements()) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.getRoutedStatements().clear();
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final boolean isPoolable() {
        return this.poolable;
    }

    @Override
    public final void setPoolable(boolean poolable) throws SQLException {
        this.poolable = poolable;
        this.recordMethodInvocation(this.targetClass, "setPoolable", new Class[]{Boolean.TYPE}, new Object[]{poolable});
        for (Statement statement : this.getRoutedStatements()) {
            statement.setPoolable(poolable);
        }
    }

    @Override
    public final int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
        this.recordMethodInvocation(this.targetClass, "setFetchSize", new Class[]{Integer.TYPE}, new Object[]{rows});
        for (Statement statement : this.getRoutedStatements()) {
            statement.setFetchSize(rows);
        }
    }

    @Override
    public final void setEscapeProcessing(boolean enable) throws SQLException {
        this.recordMethodInvocation(this.targetClass, "setEscapeProcessing", new Class[]{Boolean.TYPE}, new Object[]{enable});
        for (Statement statement : this.getRoutedStatements()) {
            statement.setEscapeProcessing(enable);
        }
    }

    @Override
    public final void cancel() throws SQLException {
        for (Statement statement : this.getRoutedStatements()) {
            statement.cancel();
        }
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        long result = 0L;
        boolean hasResult = false;
        for (Statement statement : this.getRoutedStatements()) {
            if (statement.getUpdateCount() > -1) {
                hasResult = true;
            }
            result += (long)statement.getUpdateCount();
        }
        if (result > Integer.MAX_VALUE) {
            result = Integer.MAX_VALUE;
        }
        return hasResult ? Long.valueOf(result).intValue() : -1;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public final boolean getMoreResults() {
        return false;
    }

    @Override
    public final boolean getMoreResults(int current) {
        return false;
    }

    @Override
    public final int getMaxFieldSize() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? 0 : this.getRoutedStatements().iterator().next().getMaxFieldSize();
    }

    @Override
    public final void setMaxFieldSize(int max) throws SQLException {
        this.recordMethodInvocation(this.targetClass, "setMaxFieldSize", new Class[]{Integer.TYPE}, new Object[]{max});
        for (Statement statement : this.getRoutedStatements()) {
            statement.setMaxFieldSize(max);
        }
    }

    @Override
    public final int getMaxRows() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? -1 : this.getRoutedStatements().iterator().next().getMaxRows();
    }

    @Override
    public final void setMaxRows(int max) throws SQLException {
        this.recordMethodInvocation(this.targetClass, "setMaxRows", new Class[]{Integer.TYPE}, new Object[]{max});
        for (Statement statement : this.getRoutedStatements()) {
            statement.setMaxRows(max);
        }
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? 0 : this.getRoutedStatements().iterator().next().getQueryTimeout();
    }

    @Override
    public final void setQueryTimeout(int seconds) throws SQLException {
        this.recordMethodInvocation(this.targetClass, "setQueryTimeout", new Class[]{Integer.TYPE}, new Object[]{seconds});
        for (Statement statement : this.getRoutedStatements()) {
            statement.setQueryTimeout(seconds);
        }
    }

    protected abstract Collection<? extends Statement> getRoutedStatements();

    @ConstructorProperties(value={"targetClass"})
    public AbstractStatementAdapter(Class<? extends Statement> targetClass) {
        this.targetClass = targetClass;
    }
}

