/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core.datasource;

import io.shardingsphere.core.api.ConfigMapContext;
import io.shardingsphere.core.constant.ShardingProperties;
import io.shardingsphere.core.constant.ShardingPropertiesConstant;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.executor.ExecutorEngine;
import io.shardingsphere.core.jdbc.adapter.AbstractDataSourceAdapter;
import io.shardingsphere.core.jdbc.core.ShardingContext;
import io.shardingsphere.core.jdbc.core.connection.ShardingConnection;
import io.shardingsphere.core.jdbc.metadata.JDBCShardingMetaData;
import io.shardingsphere.core.rule.ShardingRule;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class ShardingDataSource
extends AbstractDataSourceAdapter
implements AutoCloseable {
    private ShardingProperties shardingProperties;
    private ExecutorEngine executorEngine;
    private ShardingContext shardingContext;

    public ShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule) throws SQLException {
        this(dataSourceMap, shardingRule, new ConcurrentHashMap<String, Object>(), new Properties());
    }

    public ShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, Map<String, Object> configMap, Properties props) throws SQLException {
        super(dataSourceMap.values());
        if (!configMap.isEmpty()) {
            ConfigMapContext.getInstance().getShardingConfig().putAll(configMap);
        }
        this.shardingProperties = new ShardingProperties(null == props ? new Properties() : props);
        int executorSize = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        this.executorEngine = new ExecutorEngine(executorSize);
        JDBCShardingMetaData shardingMetaData = new JDBCShardingMetaData(dataSourceMap, shardingRule, this.getDatabaseType());
        shardingMetaData.init(shardingRule);
        boolean showSQL = (Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
        this.shardingContext = new ShardingContext(dataSourceMap, shardingRule, this.getDatabaseType(), this.executorEngine, shardingMetaData, showSQL);
    }

    public void renew(Map<String, DataSource> newDataSourceMap, ShardingRule newShardingRule, Properties newProps) {
        int newExecutorSize;
        ShardingProperties newShardingProperties = new ShardingProperties(null == newProps ? new Properties() : newProps);
        int originalExecutorSize = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        if (originalExecutorSize != (newExecutorSize = ((Integer)newShardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE)).intValue())) {
            ExecutorEngine originalExecutorEngine = this.executorEngine;
            this.executorEngine = new ExecutorEngine(newExecutorSize);
            originalExecutorEngine.close();
        }
        boolean newShowSQL = (Boolean)newShardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
        JDBCShardingMetaData shardingMetaData = new JDBCShardingMetaData(newDataSourceMap, newShardingRule, this.getDatabaseType());
        try {
            shardingMetaData.init(newShardingRule);
        }
        catch (SQLException ex) {
            throw new ShardingException((Exception)ex);
        }
        this.shardingProperties = newShardingProperties;
        this.shardingContext = new ShardingContext(newDataSourceMap, newShardingRule, this.getDatabaseType(), this.executorEngine, shardingMetaData, newShowSQL);
    }

    @Override
    public ShardingConnection getConnection() {
        return new ShardingConnection(this.shardingContext);
    }

    @Override
    public void close() {
        this.executorEngine.close();
    }

    public ShardingProperties getShardingProperties() {
        return this.shardingProperties;
    }
}

