/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.metadata;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.jdbc.metadata.ShardingMetaDataHandlerFactory;
import io.shardingsphere.core.metadata.ColumnMetaData;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.ShardingDataSourceNames;
import io.shardingsphere.core.rule.ShardingRule;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;

public final class JDBCShardingMetaData
extends ShardingMetaData {
    private final Map<String, DataSource> dataSourceMap;
    private final ShardingRule shardingRule;
    private final DatabaseType databaseType;

    public Collection<ColumnMetaData> getColumnMetaDataList(DataNode dataNode, ShardingDataSourceNames shardingDataSourceNames, Map<String, Connection> connectionMap) throws SQLException {
        String dataSourceName = shardingDataSourceNames.getRawMasterDataSourceName(dataNode.getDataSourceName());
        if (connectionMap.containsKey(dataSourceName)) {
            return ShardingMetaDataHandlerFactory.newInstance(dataNode.getTableName(), this.databaseType).getColumnMetaDataList(connectionMap.get(dataSourceName));
        }
        return ShardingMetaDataHandlerFactory.newInstance(this.dataSourceMap.get(dataSourceName), dataNode.getTableName(), this.databaseType).getColumnMetaDataList();
    }

    @ConstructorProperties(value={"dataSourceMap", "shardingRule", "databaseType"})
    public JDBCShardingMetaData(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, DatabaseType databaseType) {
        this.dataSourceMap = dataSourceMap;
        this.shardingRule = shardingRule;
        this.databaseType = databaseType;
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

