/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.test;

import io.smallrye.mutiny.helpers.test.AssertionHelper;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.CompletableFuture;

public class UniAssertSubscriber<T>
implements UniSubscriber<T> {
    private volatile boolean cancelImmediatelyOnSubscription;
    private volatile UniSubscription subscription;
    private volatile T item;
    private volatile Throwable failure;
    private volatile boolean completed;
    private final CompletableFuture<T> future = new CompletableFuture();
    private volatile String onResultThreadName;
    private volatile String onErrorThreadName;
    private volatile String onSubscribeThreadName;

    public UniAssertSubscriber(boolean cancelled) {
        this.cancelImmediatelyOnSubscription = cancelled;
    }

    public UniAssertSubscriber() {
        this(false);
    }

    public static <T> UniAssertSubscriber<T> create() {
        return new UniAssertSubscriber<T>();
    }

    @Override
    public synchronized void onSubscribe(UniSubscription subscription) {
        this.onSubscribeThreadName = Thread.currentThread().getName();
        if (this.cancelImmediatelyOnSubscription) {
            this.subscription = subscription;
            subscription.cancel();
            this.future.cancel(false);
            return;
        }
        this.subscription = subscription;
    }

    @Override
    public synchronized void onItem(T item) {
        this.completed = true;
        this.item = item;
        this.onResultThreadName = Thread.currentThread().getName();
        this.future.complete(item);
    }

    @Override
    public synchronized void onFailure(Throwable failure) {
        this.failure = failure;
        this.onErrorThreadName = Thread.currentThread().getName();
        this.future.completeExceptionally(failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniAssertSubscriber<T> await() {
        CompletableFuture<T> fut;
        UniAssertSubscriber uniAssertSubscriber = this;
        synchronized (uniAssertSubscriber) {
            fut = this.future;
        }
        try {
            fut.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public synchronized UniAssertSubscriber<T> assertCompleted() {
        AssertionHelper.shouldHaveCompleted(this.completed, this.failure, null);
        return this;
    }

    public synchronized UniAssertSubscriber<T> assertFailed() {
        AssertionHelper.shouldHaveFailed(this.completed, this.failure, null, null);
        return this;
    }

    public synchronized T getItem() {
        return this.item;
    }

    public synchronized Throwable getFailure() {
        return this.failure;
    }

    public UniAssertSubscriber<T> assertItem(T expected) {
        AssertionHelper.shouldHaveCompleted(this.completed, this.failure, null);
        AssertionHelper.shouldHaveReceived(this.getItem(), expected);
        return this;
    }

    public UniAssertSubscriber<T> assertFailedWith(Class<? extends Throwable> expectedTypeOfFailure, String expectedMessage) {
        AssertionHelper.shouldHaveFailed(this.completed, this.failure, expectedTypeOfFailure, expectedMessage);
        return this;
    }

    public String getOnItemThreadName() {
        return this.onResultThreadName;
    }

    public String getOnFailureThreadName() {
        return this.onErrorThreadName;
    }

    public String getOnSubscribeThreadName() {
        return this.onSubscribeThreadName;
    }

    public void cancel() {
        if (this.subscription == null) {
            this.cancelImmediatelyOnSubscription = true;
        } else {
            this.subscription.cancel();
        }
    }

    public UniAssertSubscriber<T> assertTerminated() {
        AssertionHelper.shouldBeTerminated(this.completed, this.failure);
        return this;
    }

    public UniAssertSubscriber<T> assertNotTerminated() {
        AssertionHelper.shouldNotBeTerminated(this.completed, this.failure);
        return this;
    }

    public UniAssertSubscriber<T> assertSubscribed() {
        AssertionHelper.shouldBeSubscribed(this.subscription == null ? 0 : 1);
        return this;
    }

    public UniAssertSubscriber<T> assertNotSubscribed() {
        AssertionHelper.shouldNotBeSubscribed(this.subscription == null ? 0 : 1);
        return this;
    }
}

